#!/bin/sh

#set -ux
set -u
LANG=C

#initial
export TK_HOME=/opt/TAKACOM

#make directory
mkdir -p $TK_HOME/lst
mkdir -p $TK_HOME/lst/mail
mkdir -p $TK_HOME/reg
mkdir -p $TK_HOME/set
mkdir -p $TK_HOME/set/MAIL
mkdir -p $TK_HOME/set/MESSAGE
mkdir -p $TK_HOME/set/NOTICE
mkdir -p $TK_HOME/set/SETTING
mkdir -p $TK_HOME/syslog
mkdir -p $TK_HOME/tklog
mkdir -p $TK_HOME/tklog/dbg
mkdir -p $TK_HOME/tklog/log
mkdir -p $TK_HOME/tklog/tmp

#chmod directory
chmod -R 0777 $TK_HOME

#change mq setting
#echo 100 > /proc/sys/fs/mqueue/msg_max

#call maintenance shell
cd $TK_HOME
$TK_HOME/tk_mainte_01.sh
$TK_HOME/tk_mainte_02.sh
$TK_HOME/tk_mainte_03.sh

#
#start sys_proc.tako
#

$TK_HOME/SYS_proc/sys_proc.tako
ret=$?
echo "exited sys_proc.tako ret=$ret"

#check fmng_proc
id=$(ps -aux | grep fmng_proc.tako | grep -v grep | awk '{ print $2 }')
if [ -z $id ]
then
    #umount SDcard for not run fmng_proc
    echo "umount SDcard"
    umount /mnt
fi

#check result
if [ $ret -eq  2 ]     # normal
then
    echo "sys_proc normal"
elif [ $ret -eq  3 ]   # reboot
then
    echo "sys_proc reboot"
#   wait sub to spi health check timeout
elif [ $ret -eq  4 ]   # mq to spi
then
    echo "sys_proc mq"
    id=$(ps -aux | grep spi_proc.tako | grep -v grep | awk '{ print $2 }')
    kill -s USR2 $id
elif [ $ret -eq  0 ]   # error
then
    echo "sys_proc error"
else                   # unknown
    echo "unknown"
fi
