import sys, time, threading, secrets, flask_login, os, datetime, base64, glob
from flask import Flask, request, redirect, render_template, flash, session, make_response, url_for, jsonify, render_template_string, abort
from secrets import token_urlsafe
from werkzeug.security import generate_password_hash, check_password_hash
from datetime import timedelta
from flask_wtf.csrf import CSRFProtect, CSRFError
from waitress import serve
from ctypes import *

# ======================================================================================================================== #
# 全体定義
# ======================================================================================================================== #

PORT_NUM_DEF                = 80                        #           ：ポート番号初期値（取得失敗用）
HEALTH_CHK_SEC              = 1                         #           ：ヘルスチェック秒
WEB_THREADS_CNT             = 1                         #           ：WEBスレッド数
HOST_ADR                    = '0.0.0.0'                 #           ：Waitresサーバ公開用アドレス
INI_0                       = 0                         #           ：初期値0

INI_C_ID                    = 2000                      #           ：共有ライブラリ初期値（per_idx）
INI_C_NAME                  = 30 + 1                    #           ：共有ライブラリ初期値（c_web_name）
INI_C_NUM                   = 20 + 1                    #           ：共有ライブラリ初期値（c_web_pw,c_tel）
INI_C_MAIL                  = 128 + 1                   #           ：共有ライブラリ初期値（c_mail）
INI_C_OTH                   = -1                        #           ：共有ライブラリ初期値（type,web_use,web_timeout,web_res,web_port）
TYPE_OUTSIDE                = 0                         #           ：電話番号種別：外線
TYPE_EXTENSION              = 1                         #           ：電話番号種別：内線

# ログ
LOG_TYPE_ERROR              = 'Err'                     # 種別      ：エラー
LOG_TYPE_INFO               = 'Ntc'                     #           ：情報
LOG_TYPE_Trace              = 'Trc'                     #           ：トレース
LOG_TYPE_DEBUG              = 'Dbg'                     #           ：デバッグ
LOG_DATA_PRO_ID             = 6                         #           ：プロセスID
LOG_DATA_THR_ID             = 0                         #           ：スレッドID
LOG_PATH_WEB                = 'web_proc.log'            # ファイル名 ：WEBプロセス

# フォーマット
FMT_FNAME_LOG_HST           = '%s.%02d'                 # ログ履歴

ARGV_WEB_DIR_LOG            = 11                        #           ：ログ保存先
ARGV_WEB_SIZE_LOG           = 12                        #           ：ログサイズ
ARGV_WEB_CNT_LOG            = 13                        #           ：ログ履歴保存数
SETTING_WEB_DIR_LOG         = '/opt/TAKACOM/tklog/dbg'  #           ：ログ保存先
SETTING_WEB_SIZE_LOG        = 1000                      #           ：ログサイズ
SETTING_WEB_CNT_LOG         = 2                         #           ：ログ履歴保存数

SETTING_WEB_DIR_VER         = '/opt/TAKACOM/WEB_proc/ARS900-web_proc-*' #   ：バージョンファイル名

class cls_setting:
	def __init__(self):
		self.dir_log        =   SETTING_WEB_DIR_LOG     # ログ保存先
		self.size_log       =   SETTING_WEB_SIZE_LOG    # ログサイズ
		self.cnt_log        =   SETTING_WEB_CNT_LOG     # ログ履歴保存数

	def set_(self, argv):
		# 引数カウント
		argv_len            = len(argv) - 1
		print("[INFO____] 引数             : %d" % (argv_len))

		# 設定値セット
		self.dir_log        =     argv[ARGV_WEB_DIR_LOG]      if argv_len >= ARGV_WEB_DIR_LOG      else     SETTING_WEB_DIR_LOG       # ログ保存先
		self.size_log       = int(argv[ARGV_WEB_SIZE_LOG])    if argv_len >= ARGV_WEB_SIZE_LOG     else int(SETTING_WEB_SIZE_LOG)     # ログサイズ
		self.cnt_log        = int(argv[ARGV_WEB_CNT_LOG])     if argv_len >= ARGV_WEB_CNT_LOG      else int(SETTING_WEB_CNT_LOG)      # ログ履歴保存数

	def print_(self, argv):
		print("[INFO____] ログ保存先       : %s" % (self.dir_log))
		print("[INFO____] ログサイズ       : %d" % (self.size_log))
		print("[INFO____] ログ履歴保存数   : %d" % (self.cnt_log))

# ======================================================================================================================== #
# WEBスレッド開始関数
# ======================================================================================================================== #

app = Flask(__name__)

def thread_web():
    serve(app, host=HOST_ADR, port=PORT_NUM, threads=WEB_THREADS_CNT)

# ======================================================================================================================== #
# タテ積み関数（未使用）
# ======================================================================================================================== #

# import queue
# import functools

# singleQueue = queue.Queue(maxsize=1)

# def multiple_control(q):
#     def _multiple_control(func):
#         @functools.wraps(func)
#         def wrapper(*args,**kwargs):
#             q.put(time.time())
#             print("/// [start] critial zone")
#             result = func(*args,**kwargs)
#             print("/// [end] critial zone")
#             q.get()
#             q.task_done()
#             return result
#         return wrapper
#     return _multiple_control

# ======================================================================================================================== #
# WEBスレッド定義
# ======================================================================================================================== #

app.secret_key      = secrets.token_hex(32) # 暗号化用セッションキー

CHARASET            = 'utf-8'               # 文字コード（主装置と統一）
SESSIONOUT_COUNT    = 1                     # セッションのライフタイム秒
MQ_SLEEP_CNT        = 100/1000              # メッセージキュー受信待機ミリ秒
MQ_TIMEOUT_CNT      = 10                    # メッセージキュー受信タイムアウト秒
MQ_TIMEOUT_FILE_CNT = 60                    # メッセージキュー受信タイムアウト秒（ファイル保存のみ）
NONCE_NUM_KEY       = 32                    # NONCEキー
ERROR_HANDLER_CNT   = 0                     # エラー検知回数
ERROR_HANDLER_LIMIT = 10                    # エラー検知回数上限


# ログインマネージャー
login_manager       = flask_login.LoginManager()
login_manager.init_app(app)

# CSRF対策トークン
csrf = CSRFProtect()
csrf.init_app(app)

# ユーザークラス
class User(flask_login.UserMixin):
    def __init__(self, userid):
        self.id = userid

# 例外クラス
class MyException(Exception):
    def __init__(self, code, message):
        self.code = code
        self.message = message
    def __str__(self):
        return repr(self.message)

# ヘッダー情報
@app.after_request
def after_request(response):
    response.headers['X-Content-Type-Options']      = 'nosniff'
    # response.headers['Cache-Control']               = 'no-cache'
    response.headers['Cache-Control']               = 'max-age=0'
    # response.headers['Strict-Transport-Security']   = 'max-age=31536000; includeSubDomains'
    # response.headers['X-Frame-Options']             = 'SAMEORIGIN'
    response.headers['X-XSS-Protection']            = '1; mode=block'
    app.config.update(
        SESSION_COOKIE_SECURE                   = False,
        SESSION_COOKIE_HTTPONLY                 = True,
        SESSION_COOKIE_SAMESITE                 = 'Lax',
    )
    return response

# ログインマネージャー
@login_manager.user_loader
def load_user(userid):
    # return User(userid)
    try:
        user = User(userid)
        return user
    except KeyError:
        return None

# ======================================================================================================================== #
# ルーティング
# ======================================================================================================================== #

# 最初のページ
@app.route("/", methods=["GET", "POST"])
def index():
    return redirect('/login')

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# ログイン画面
@app.route('/login', methods=['GET'])
def login():
    try:
        # 初期化
        global ERROR_HANDLER_CNT
        ERROR_HANDLER_CNT = 0
        # ページ渡し
        NONCE_NUM = token_urlsafe(NONCE_NUM_KEY)
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("GET login. OK."))
        response = make_response(render_template('login.html', version = VERSION, js_key = NONCE_NUM))
        response.headers['Content-Security-Policy'] = \
            "default-src 'self' ; script-src 'nonce-%s' ; img-src data:, ; frame-ancestors 'self'" % (NONCE_NUM)
        return response
    except:
        # ページ渡し
        NONCE_NUM = token_urlsafe(NONCE_NUM_KEY)
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format("GET login. NG exception."))
        response = make_response(render_template('login.html', version = VERSION, js_key = NONCE_NUM))
        response.headers['Content-Security-Policy'] = \
            "default-src 'self' ; script-src 'nonce-%s' ; img-src data:, ; frame-ancestors 'self'" % (NONCE_NUM)
        return response

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

@app.route('/login',methods=['POST'])
def login_post():
    try:
        # 初期化
        MSG_1       = 'ログインできません。'                                                    # メッセージ1行目デフォルト
        MSG_2       = 'しばらく時間をおいてからログインし直すか、管理者にお問い合わせください。'    # メッセージ1行目デフォルト
        web_use     = c_int(INI_C_OTH)                                                          # WEB機能ON/OFF取得変数
        web_timeout = c_int(INI_C_OTH)                                                          # 自動タイムアウト取得変数

        # WEB機能,自動タイムアウト取得
        ret = libc.lib_shm_get_init_set_web(byref(web_use), byref(web_timeout))
        if ret != libc.lib_shm_chk_ret_ok():
            raise MyException(1, format("POST login. NG error lib_shm_get_init_set_web. (ret:%d)" % (ret)))

        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_DEBUG, \
            format("POST login. lib_shm_get_init_set_web (web_use=%d) (web_timeout=%d)" % (web_use.value,web_timeout.value)))

        if web_use.value == int(False):
            # WEB機能OFF
            raise MyException(2, format("POST login. NG not web_use. (ret:%d) (web_use:%d)" % (ret,web_use.value)))

        per_idx     = c_int(libc.lib_shm_get_per_cnt_max())
        c_web_name  = c_char_p(str(list(range(INI_C_NAME))).encode(CHARASET))
        c_web_pw    = c_char_p(str(list(range(INI_C_NUM))).encode(CHARASET))
        c_tel_1     = c_char_p(str(list(range(INI_C_NUM))).encode(CHARASET))
        c_tel_2     = c_char_p(str(list(range(INI_C_NUM))).encode(CHARASET))
        type1       = c_int(INI_C_OTH)
        type2       = c_int(INI_C_OTH)
        c_mail_1    = c_char_p(str(list(range(INI_C_MAIL))).encode(CHARASET))
        c_mail_2    = c_char_p(str(list(range(INI_C_MAIL))).encode(CHARASET))

        userid = request.form['userid']
        web_pw = request.form['password']
        # web_pw = base64.b64decode(request.form['password']).decode()
        # web_pw = generate_password_hash(request.form['password'], method='sha256')

        # 個人情報取得
        ret = libc.lib_shm_get_per_info(c_char_p(userid.encode(CHARASET)), byref(per_idx), \
                c_web_name, c_web_pw, byref(type1), c_tel_1, byref(type2), c_tel_2, c_mail_1, c_mail_2)
        if ret != libc.lib_shm_chk_ret_ok():
            raise MyException(1, format("POST login. NG error lib_shm_get_per_info. (ret:%d) (userid:%s)" % (ret,userid)))

        # ログイン判定
        if per_idx.value < libc.lib_shm_get_per_cnt_max() and web_pw == c_web_pw.value.decode(CHARASET):
        # if per_idx.value < libc.lib_shm_get_per_cnt_max() and check_password_hash(web_pw, c_web_pw.value.decode(CHARASET)) == True:
            # 登録値の取得
            session['id']           = per_idx.value
            session['userid']       = userid
            session['password']     = c_web_pw.value.decode(CHARASET)
            session['name']         = c_web_name.value.decode(CHARASET)
            session['phone_num1']   = c_tel_1.value.decode(CHARASET)
            session['type1']        = type1.value
            session['phone_num2']   = c_tel_2.value.decode(CHARASET)
            session['type2']        = type2.value
            session['mail1']        = c_mail_1.value.decode(CHARASET)
            session['mail2']        = c_mail_2.value.decode(CHARASET)
            session['timeout']      = web_timeout.value

            # ユーザーセッション生成
            user = User(userid)
            flask_login.login_user(user)
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("POST login. OK. (userid:%s)" % (userid)))
            return redirect('/register')
        else:
            raise MyException(3, format("POST login. NG not match. (ret:%d) (userid:%s)" % (ret,userid)))

    except MyException as ex:
        if ex.code == 1:
            MSG_1 = 'ログインできません。'
            MSG_2 = 'しばらく時間をおいてからログインし直すか、管理者にお問い合わせください。'
        elif ex.code == 2:
            MSG_1 = 'ブラウザ機能が無効になっています。管理者にお問い合わせください。'
            MSG_2 = ''
        elif ex.code == 3:
            MSG_1 = 'IDまたはパスワードが一致しません。'
            MSG_2 = '入力し直してください。'
        else:
            pass
        flash(MSG_1)
        flash(MSG_2)
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, ex.message)

    except:
        flash('ログインできません。')
        flash('しばらく時間をおいてからログインし直すか、管理者にお問い合わせください。')
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format("POST login. NG exception."))

    return redirect('/login')

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# 情報登録画面
@app.route('/register', methods=['GET'])
@flask_login.login_required
def register():
    try:
        #
        # セッションの寿命の設定
        #
        # session.permanent = True  # 画面更新->ライフタイムリセット（今回実装なし）
        app.permanent_session_lifetime = timedelta(hours = SESSIONOUT_COUNT)
        # session.modified = True   # 画面更新->ライフタイムリセット（今回実装なし）

        #
        # 登録値の取得
        #
        userid          = session['userid']
        name            = session['name']
        timeout         = session['timeout']

        # 登録失敗用の処理
        if 'tmp_phone_num1' in session and 'tmp_type1' in session and 'tmp_phone_num2' in session \
            and 'tmp_type2' in session and 'tmp_mail1' in session and 'tmp_mail2' in session:
            phone_num1      = session['tmp_phone_num1']
            type1           = session['tmp_type1']
            phone_num2      = session['tmp_phone_num2']
            type2           = session['tmp_type2']
            mail1           = session['tmp_mail1']
            mail2           = session['tmp_mail2']

            # 画面更新で元の値に戻す
            session.pop('tmp_phone_num1', None)
            session.pop('tmp_type1', None)
            session.pop('tmp_phone_num2', None)
            session.pop('tmp_type2', None)
            session.pop('tmp_mail1', None)
            session.pop('tmp_mail2', None)
        else:
            phone_num1      = session['phone_num1']
            type1           = session['type1']
            phone_num2      = session['phone_num2']
            type2           = session['type2']
            mail1           = session['mail1']
            mail2           = session['mail2']

        #
        # ページ渡し
        #
        NONCE_NUM = token_urlsafe(NONCE_NUM_KEY)
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("GET register. (userid:%s)" % (session['userid'])))
        response = make_response(render_template('register.html', userid=userid, name=name, phone_num1=phone_num1, type1=type1, \
                    phone_num2=phone_num2, type2=type2, mail1=mail1, mail2=mail2, timeout_count=timeout, js_key = NONCE_NUM))
        response.headers['Content-Security-Policy'] \
            = "default-src 'self' ; script-src 'nonce-%s' ; img-src data:, ; frame-ancestors 'self'" % (NONCE_NUM)
        return response

    except:
        flash('ログインできません。')
        flash('しばらく時間をおいてからログインし直すか、管理者にお問い合わせください。')
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format("GET register. NG exception."))
        return redirect('/login')

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

@app.route('/register', methods=['POST'])
@flask_login.login_required
# @multiple_control(singleQueue)
def register_post():
    try:
        # 初期化
        MSG_1                   = '登録しました。'          # メッセージ1行目デフォルト
        MSG_2                   = ''                        # メッセージ2行目デフォルト
        web_use                 = c_int(INI_C_OTH)          # WEB機能ON/OFF取得変数
        web_timeout             = c_int(INI_C_OTH)          # 自動タイムアウト取得変数
        i                       = float(INI_0)              # メッセージキュー受信待ちループ変数
        dup_res                 = c_int(INI_C_OTH)          # 重複確認用変数
        session['tmp_password'] = session['password']       # 変更前パスワードの保持
        GO_LOGIN                = 0                         # ログイン画面遷移用変数
        per_idx                 = c_int(INI_C_ID)           # ユーザー存在チェック用変数

        # 登録用一時データ作成
        session['tmp_phone_num1']   = request.form['phone_num1']
        session['tmp_type1']        = request.form['phone_sel1']
        session['tmp_phone_num2']   = request.form['phone_num2']
        session['tmp_type2']        = request.form['phone_sel2']
        session['tmp_mail1']        = request.form['mail1']
        session['tmp_mail2']        = request.form['mail2']
        if request.form['password'] != '':
            session['tmp_password'] = request.form['password']

        #
        # WEB機能ON/OFF取得
        #

        ret = libc.lib_shm_get_init_set_web(byref(web_use), byref(web_timeout))
        if ret != libc.lib_shm_chk_ret_ok():
            # WEB機能取得エラー
            raise MyException(1, format("POST register. NG error lib_shm_get_init_set_web. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_DEBUG, \
            format("POST register. lib_shm_get_init_set_web (web_use=%d) (web_timeout=%d)" % (web_use.value,web_timeout.value)))

        # WEB機能チェック
        if web_use.value == int(False):
            # WEB機能OFF
            raise MyException(3, format("POST register. NG not web_use. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        #
        # ユーザー存在チェック
        #

        ret = libc.lib_shm_get_per_idx(c_char_p(str(session['userid']).encode(CHARASET)), c_char_p(str(session['name']).encode(CHARASET)), byref(per_idx))
        if ret != libc.lib_shm_chk_ret_ok():
            # ユーザー取得エラー
            raise MyException(1, format("POST register. NG error lib_shm_get_per_idx. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_DEBUG, \
            format("POST register. lib_shm_get_per_idx (per_idx=%d)" % (per_idx.value)))

        if per_idx.value == INI_C_ID:
            raise MyException(4, format("POST register. NG deleted user. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        #
        # MQ登録開始要求
        #

        ret = libc.lib_shm_set_chg_start()
        if ret != libc.lib_shm_chk_ret_ok():
            # MQ登録開始要求エラー
            raise MyException(1, format("POST register. NG error lib_shm_set_chg_start. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        # MQ受信チェック
        i = float(INI_0)
        while True:
            web_res = c_int(INI_C_OTH)
            ret     = libc.lib_shm_mq_rcv(byref(web_res))
            if ret != libc.lib_shm_chk_ipc_rcv_timeout():
                # MQ受信完了
                break
            if i >= MQ_TIMEOUT_CNT:
                # タイムアウト
                raise MyException(1, format("POST register. NG timeout. (ret:%d) (userid:%s)" % (ret,session['userid'])))
            time.sleep(MQ_SLEEP_CNT)
            i = i + MQ_SLEEP_CNT

        # 開始要求結果チェック
        if ret != libc.lib_shm_chk_ret_ok():
            # MQ開始取得エラー
            raise MyException(1, format("POST register. NG error lib_shm_mq_rcv. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        if web_res.value == int(False):
            # MQ開始禁止
            raise MyException(2, format("POST register. NG busy. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        try:
            #
            # 登録更新
            #

            per_idx         = session['id']
            type1           = int(session['tmp_type1'])
            c_tel_1         = c_char_p(str(session['tmp_phone_num1']).encode(CHARASET))
            type2           = int(session['tmp_type2'])
            c_tel_2         = c_char_p(str(session['tmp_phone_num2']).encode(CHARASET))
            c_mail_1        = c_char_p(str(session['tmp_mail1']).encode(CHARASET))
            c_mail_2        = c_char_p(str(session['tmp_mail2']).encode(CHARASET))
            c_web_pw_new    = c_char_p(str(session['tmp_password']).encode(CHARASET))


            # 電話番号重複確認
            ret = libc.lib_shm_chk_dup_per_tel(per_idx, c_tel_1, byref(dup_res))
            if ret != libc.lib_shm_chk_ret_ok():
                # 共有メモリ読み込みエラー
                raise MyException(1, format("POST register. NG error lib_shm_chk_dup_per_tel. (ret:%d) (userid:%s)" % (ret,session['userid'])))
            if dup_res.value == int(True):
                # 他ユーザーと電話番号が重複
                raise MyException(2, format("POST register. NG error lib_shm_chk_dup_per_tel c_tel_1. (userid:%s)" % (session['userid'])))

            ret = libc.lib_shm_chk_dup_per_tel(per_idx, c_tel_2, byref(dup_res))
            if ret != libc.lib_shm_chk_ret_ok():
                # 共有メモリ読み込みエラー
                raise MyException(1, format("POST register. NG error lib_shm_chk_dup_per_tel. (ret:%d) (userid:%s)" % (ret,session['userid'])))
            if dup_res.value == int(True):
                # 他ユーザーと電話番号が重複
                raise MyException(3, format("POST register. NG error lib_shm_chk_dup_per_tel c_tel_2. (userid:%s)" % (session['userid'])))

            # メールアドレス重複確認
            ret = libc.lib_shm_chk_dup_per_mail(per_idx, c_mail_1, byref(dup_res))
            if ret != libc.lib_shm_chk_ret_ok():
                # 共有メモリ読み込みエラー
                raise MyException(1, format("POST register. NG error lib_shm_chk_dup_per_mail. (ret:%d) (userid:%s)" % (ret,session['userid'])))
            if dup_res.value == int(True):
                # 他ユーザーとメールアドレスが重複
                raise MyException(4, format("POST register. NG error lib_shm_chk_dup_per_mail c_mail_1. (userid:%s)" % (session['userid'])))

            ret = libc.lib_shm_chk_dup_per_mail(per_idx, c_mail_2, byref(dup_res))
            if ret != libc.lib_shm_chk_ret_ok():
                # 共有メモリ読み込みエラー
                raise MyException(1, format("POST register. NG error lib_shm_chk_dup_per_mail. (ret:%d) (userid:%s)" % (ret,session['userid'])))
            if dup_res.value == int(True):
                # 他ユーザーとメールアドレスが重複
                raise MyException(5, format("POST register. NG error lib_shm_chk_dup_per_mail c_mail_2. (userid:%s)" % (session['userid'])))


            # 共有メモリ書き込み
            ret = libc.lib_shm_wt_per_info(per_idx, type1, c_tel_1, type2, c_tel_2, c_mail_1, c_mail_2, c_web_pw_new)
            if ret != libc.lib_shm_chk_ret_ok():
                # 共有メモリ書き込みエラー
                raise MyException(1, format("POST register. NG error lib_shm_wt_per_info. (ret:%d) (userid:%s)" % (ret,session['userid'])))

            # MQ個人情報更新要求
            ret = libc.lib_shm_mq_snd_chg_per_info_to_ars(per_idx)
            if ret != libc.lib_shm_chk_ret_ok():
                # MQ個人情報更新要求エラー
                raise MyException(1, format("POST register. NG error lib_shm_mq_snd_chg_per_info_to_ars. (ret:%d) (userid:%s)" % (ret,session['userid'])))

            # MQ受信チェック
            i = float(INI_0)
            while True:
                web_res = c_int(INI_C_OTH)
                ret     = libc.lib_shm_mq_rcv(byref(web_res))
                if ret != libc.lib_shm_chk_ipc_rcv_timeout():
                    # MQ受信完了
                    break
                if i >= MQ_TIMEOUT_FILE_CNT:
                    # タイムアウト
                    raise MyException(1, format("POST register. NG timeout. (ret:%d) (userid:%s)" % (ret,session['userid'])))
                time.sleep(MQ_SLEEP_CNT)
                i = i + MQ_SLEEP_CNT

            # 登録更新結果チェック
            if ret == libc.lib_shm_chk_ret_ok() and web_res.value == libc.lib_shm_chk_chg_per_info_ret_ok():
                # 登録終了
                # Flask側データ格納
                session['phone_num1']   = session['tmp_phone_num1']
                session['type1']        = session['tmp_type1']
                session['phone_num2']   = session['tmp_phone_num2']
                session['type2']        = session['tmp_type2']
                session['mail1']        = session['tmp_mail1']
                session['mail2']        = session['tmp_mail2']
                session['password']     = session['tmp_password']
                session.pop('tmp_phone_num1', None)
                session.pop('tmp_type1', None)
                session.pop('tmp_phone_num2', None)
                session.pop('tmp_type2', None)
                session.pop('tmp_mail1', None)
                session.pop('tmp_mail2', None)
                session.pop('tmp_password', None)
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                    format("POST register. OK(success lib_shm_mq_snd_chg_per_info_to_ars. (userid:%s))" % (session['userid'])))
            # 登録更新エラー
            else:
                raise MyException(1, \
                    format("POST register. NG error lib_shm_mq_snd_chg_per_info_to_ars. (ret:%d) (web_res:0x%02x) (userid:%s)" % (ret,web_res.value,session['userid'])))

        except MyException as ex:
            if ex.code == 1:
                MSG_1 = '登録できません。'
                MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
            elif ex.code == 2:
                MSG_1 = '「電話番号1」の電話番号は他のユーザーで登録されています。'
                MSG_2 = '別の電話番号を入力し直すか、管理者にお問い合わせください。'
            elif ex.code == 3:
                MSG_1 = '「電話番号2」の電話番号は他のユーザーで登録されています。'
                MSG_2 = '別の電話番号を入力し直すか、管理者にお問い合わせください。'
            elif ex.code == 4:
                MSG_1 = '「メール1」のメールアドレスは他のユーザーで登録されています。'
                MSG_2 = '別のメールアドレスを入力し直すか、管理者にお問い合わせください。'
            elif ex.code == 5:
                MSG_1 = '「メール2」のメールアドレスは他のユーザーで登録されています。'
                MSG_2 = '別のメールアドレスを入力し直すか、管理者にお問い合わせください。'
            else:
                MSG_1 = '登録できません。'
                MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, ex.message)

        except:
            MSG_1 = '登録できません。'
            MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("POST register. NG exception."))

        try:
            #
            # MQ登録終了要求
            #

            ret = libc.lib_shm_set_chg_end()
            if ret != libc.lib_shm_chk_ret_ok():
                # MQ登録終了要求エラー
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                    format("POST register. OK(error lib_shm_set_chg_end. (ret:%d) (userid:%s)" % (ret,session['userid'])))

            # MQ受信チェック
            i = float(INI_0)
            while True:
                web_res = c_int(INI_C_OTH)
                ret = libc.lib_shm_mq_rcv(byref(web_res))
                if ret != libc.lib_shm_chk_ipc_rcv_timeout():
                    # MQ受信完了
                    break
                if i >= MQ_TIMEOUT_CNT:
                    # タイムアウト
                    break
                time.sleep(MQ_SLEEP_CNT)
                i = i + (MQ_SLEEP_CNT)

            # 登録終了結果チェック
            if ret == libc.lib_shm_chk_ret_ok():
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_DEBUG, \
                    format("POST register. OK(success lib_shm_set_chg_end. (userid:%s))" % (session['userid'])))
            else:
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                    format("POST register. OK(error lib_shm_set_chg_end. (ret:%d) (userid:%s)" % (ret,session['userid'])))

        except:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format("POST register. NG exception."))

    except MyException as ex:
        if ex.code == 1:
            MSG_1 = '登録できません。'
            MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
        elif ex.code == 2:
            MSG_1 = '主装置が操作中または通知中のため登録できません。'
            MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
        elif ex.code == 3:
            MSG_1 = 'ブラウザ機能が無効になっています。管理者にお問い合わせください。'
            MSG_2 = ''
        elif ex.code == 4:
            MSG_1 = 'ご利用のIDが削除、またはIDに登録された名前が変更されたため、'
            MSG_2 = '登録できませんでした。管理者にお問合わせください。'
            GO_LOGIN = 1
        else:
            MSG_1 = '登録できません。'
            MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, ex.message)

    except:
        MSG_1 = '登録できません。'
        MSG_2 = 'しばらく時間をおいてから登録し直すか、管理者にお問い合わせください。'
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format("POST register. NG exception."))

    finally:
        if GO_LOGIN == 0:
            flash(MSG_1)
            flash(MSG_2)
            return redirect('/register')
        else:
            flask_login.logout_user()
            [session.pop(key) for key in list(session.keys())]
            flash(MSG_1)
            flash(MSG_2)
            return redirect("/login")

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# ログアウト処理
@app.route('/logout')
@flask_login.login_required
def logout():
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
        format("GET logout. (userid:%s)" % (session['userid'])))

    # [print(key) for key in list(session.keys())]
    flask_login.logout_user()
    [session.pop(key) for key in list(session.keys())]

    flash('ログアウトしました。')
    return redirect("/login")

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# タイムアウト処理
@app.route('/timeout')
@flask_login.login_required
def timeout():
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
        format("GET logout. (userid:%s)" % (session['userid'])))

    flask_login.logout_user()
    [session.pop(key) for key in list(session.keys())]

    flash('無操作状態が一定時間続いたためログアウトしました。')
    return redirect("/login")

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# 認証無しアクセスエラー
@login_manager.unauthorized_handler
def unauthorized():
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
        format("No session access."))
    return redirect('/login')

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# 404エラー
@app.errorhandler(404)
def page_not_found(e):
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
        format("404 Not Found error."))
    return render_template_string('<title>404 Not Found</title> <h1>Not Found</h1> <p>%s</p>' % (e)),404

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# 500エラー
@app.errorhandler(500)
def internal_server_error(e):
    global ERROR_HANDLER_CNT
    ERROR_HANDLER_CNT += 1
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
        format("500 error. (ERROR_HANDLER_CNT:%d)" % (ERROR_HANDLER_CNT)))
    time.sleep(SESSIONOUT_COUNT)
    if ERROR_HANDLER_CNT >= ERROR_HANDLER_LIMIT:
        return render_template_string('<title>500 Bad Request</title> <h1>Bad Request</h1> <p>%s</p>' % (e)), 500
    else:
        return redirect("/login")

# ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

# CSRFエラー
@app.errorhandler(CSRFError)
def handle_csrf_error(e):
    global ERROR_HANDLER_CNT
    ERROR_HANDLER_CNT += 1
    func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
        format("400 Bad Request error. (ERROR_HANDLER_CNT:%d)" % (ERROR_HANDLER_CNT)))
    time.sleep(SESSIONOUT_COUNT)
    if ERROR_HANDLER_CNT >= ERROR_HANDLER_LIMIT:
        return render_template_string('<title>400 Bad Request</title> <h1>Bad Request</h1> <p>%s</p>' % (e)), 400
    else:
        return redirect("/login")

# ======================================================================================================================== #
# LOG関数
# ======================================================================================================================== #

# ログファイルopen/write関数
def func_openlog(dir, fname, max_size, max_cnt, type, message, exc_msg = ''):
    # 初期化
    file    = None
    path    = dir + "/" + fname
    ext_str = ''
    try:
        if dir != '':
            # ファイルサイズチェック
            if os.path.getsize(path) >= max_size * 1000:
                # サイズ超過 -> 保存数超過分を削除
                files = os.listdir(dir)
                for file in files:
                    if os.path.isfile(dir + "/" + file) == True:
                        try:
                            # ファイル名チェック
                            ext_str = file.split(fname)[1]
                            if ext_str != '':
                                num = int(ext_str.replace('.', ''))
                                if num >= max_cnt:
                                    # 削除
                                    os.remove(dir + "/" + file)
                        except:
                            # 対象外ファイル
                            pass
                # サイクリック
                for cnt in range(max_cnt, 0, -1):
                    if cnt > 1 and os.path.isfile(FMT_FNAME_LOG_HST % (path, cnt - 1)) == True:
                        os.rename(format(FMT_FNAME_LOG_HST % (path, cnt - 1)), format(FMT_FNAME_LOG_HST % (path, cnt)))
                    elif cnt == 1:
                        os.rename(path, format(FMT_FNAME_LOG_HST % (path, cnt)))
    except:
        # サイクリックエラー ※処理は継続
        print("[ERROR___] error cycle log (%s, %s)" % (dir, fname))
    try:
        # ログ書式化
        text = func_format_log(datetime.datetime.now(), type, message, exc_msg)
        # ログファイルオープン
        with open(path, mode = 'a') as file:
            # ファイル出力
            if type != LOG_TYPE_DEBUG and file != None:
                try:
                    # ログ書き込み
                    file.write(format("%s\n" % (text)))
                except:
                    # 書き込みエラー
                    print("[ERROR___] error write log (%s, %s)" % (type, message))
        # 画面出力 ※デバッグ用
        print(text)
    except:
        # オープンエラー
        file = None
        print("[ERROR___] error open log (%s, %s)" % (dir, fname))

# ログ書式化関数
def func_format_log(datetime, type, message, exc_msg):
    # 日時 + 種別 + 内容
    text = format("%04d/%02d/%02d %02d:%02d:%02d.%03d,%d,0x%08x,%s,%s" % (datetime.year, datetime.month, datetime.day, datetime.hour, \
            datetime.minute, datetime.second, int(datetime.microsecond / 1000), LOG_DATA_PRO_ID, LOG_DATA_THR_ID, type, message))
    # 例外情報
    if exc_msg != '':
        text += format(" <%s>" % (exc_msg))
    return text

# ======================================================================================================================== #
# 開始処理
# ======================================================================================================================== #

if __name__ == "__main__":
    try:
        # バージョン取得
        for f in glob.glob(SETTING_WEB_DIR_VER):
            VERSION = os.path.split(f)[1].split('-')[2]

        # ログ設定値取得
        setting = cls_setting()
        setting.set_(sys.argv)
        setting.print_(sys.argv)

        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("********************************************************"))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("*        web_proc PROCESS Ver.%s LOG START        *" % (VERSION)))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO,\
             format("********************************************************"))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("<Log config data>---------------------------------------"))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("+ Log Level  :Notice (3)"))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("+ Max Size   :%d (Kbyte)" % (setting.size_log)))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("+ Generation :%d (files)" % (setting.cnt_log)))
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("--------------------------------------------------------"))

        # process init
        web_hc      =   c_int(INI_0)
        exit_req    =   c_int(INI_0)
        msg_cmd     =   c_int(INI_0)
        web_port    =   c_int(INI_C_OTH)
        ret         =   INI_0

        # start process ----------------------------------------------------------------------------------------------------
        # read library
        libc = cdll.LoadLibrary("/opt/TAKACOM/WEB_proc/web_proc_lib.so")

        # library initial by web proc
        ret = libc.lib_shm_initial_web()
        if ret == libc.lib_shm_chk_ret_ok():
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("start lib_shm_initial_web."))
        else:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("failed lib_shm_initial_web. (ret:%d)" % (ret)))
            raise

        # update process status run
        ret = libc.lib_shm_wt_proc_info_status_run()
        if ret == libc.lib_shm_chk_ret_ok():
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("start lib_shm_wt_proc_info_status_run."))
        else:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("failed lib_shm_wt_proc_info_status_run. (ret:%d)" % (ret)))

        # ポート番号取得
        ret = libc.lib_shm_get_main_reg_web(byref(web_port))
        if ret == libc.lib_shm_chk_ret_ok():
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("lib_shm_get_main_reg_web. (web_port:%d)" % (web_port.value)))
            PORT_NUM = web_port.value
        else:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("failed lib_shm_get_main_reg_web. (ret:%d)" % (ret)))
            PORT_NUM = PORT_NUM_DEF

        # create thread webapp
        thr_web = threading.Thread(target=thread_web)
        thr_web.setDaemon(True)
        thr_web.start()
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
            format("start process web."))

        # main loop ----------------------------------------------------------------------------------------------------
        while True:
            # update health check
            libc.lib_shm_inc_proc_info_hc(byref(web_hc))
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_DEBUG, \
                format("call function health check. (lib_shm_inc_proc_info_hc:%d)" % (web_hc.value)))

            # check exit request3
            ret = libc.lib_shm_chk_proc_req_exit_req(byref(exit_req))
            if ret == libc.lib_shm_chk_ret_ok() and exit_req.value == libc.lib_shm_chk_exit_req():
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                    format("call finish process."))
                break

            # check thread alive
            if thr_web.is_alive() == False:
                func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                    format("failed web thread."))
                raise

            # sleep 1s
            time.sleep(HEALTH_CHK_SEC)

        # finish process ----------------------------------------------------------------------------------------------------
        # update process status finish
        ret = libc.lib_shm_wt_proc_info_status_fin()
        if ret == libc.lib_shm_chk_ret_ok():
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("finish process."))
        else:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("failed finish process. (ret:%d)" % (ret)))

        # another finish

        # update process status finished
        ret = libc.lib_shm_wt_proc_info_status_fin_comp()
        if ret == libc.lib_shm_chk_ret_ok():
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_INFO, \
                format("finish process.comp."))
        else:
            func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
                format("failed finish process. (ret:%d)" % (ret)))
    except:
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format(sys.exc_info()))

    try:
        # library release by web proc
        libc.lib_shm_release_web()
    except:
        func_openlog(setting.dir_log, LOG_PATH_WEB, setting.size_log, setting.cnt_log, LOG_TYPE_ERROR, \
            format(sys.exc_info()))