# coding=UTF-8

#
#  メール送信関数ファイル
#
#      @package    mail_func_smtp_send.py
#      @author     M.Suzuki
#      @since      Python 3.6
#      @encode     UTF-8
#

import sys
import ssl
import smtplib
import function
import codecs
import time
from email.mime.text import MIMEText
from email.header import Header

from all_define    import *					# 定義ファイル
from function      import *					# 共通関数ファイル

class cls_setting:
	
	#
	# 設定値クラス
	#
	
	def __init__(self):
		
		# 初期化
		self.smtp_server  =     SETTING_INIT_SEND_SMTP_SERVER				# SMTPサーバ
		self.smtp_port    = int(SETTING_INIT_SEND_SMTP_PORT)				# SMTPポート
		self.smtp_user    =     SETTING_INIT_SEND_SMTP_USER					# SMTPユーザ
		self.smtp_pw      =     SETTING_INIT_SEND_SMTP_PW					# SMTPパスワード
		self.smtp_timeout = int(SETTING_INIT_SEND_SMTP_TIMEOUT)				# SMTPタイムアウト
		self.auth_type    = int(SETTING_INIT_SEND_SMTP_AUTH_TYPE)			# 認証方式
		self.from_addr    =     SETTING_INIT_SEND_SMTP_FROM_ADDR			# 送信元アドレス
		self.from_name    =     SETTING_INIT_SEND_SMTP_FROM_NAME			# 送信者名
		self.input_path   =     SETTING_INIT_SEND_SMTP_INPUT_PATH			# 送信情報入力元
		self.input_encode =     SETTING_INIT_SEND_SMTP_INPUT_ENCODE			# 送信情報文字コード
		self.output_path  =     SETTING_INIT_SEND_SMTP_OUTPUT_PATH			# 送信情報出力先
		self.dir_log      =     SETTING_INIT_SEND_SMTP_DIR_LOG				# ログ保存先
		self.size_log     =     SETTING_INIT_SEND_SMTP_SIZE_LOG				# ログサイズ
		self.cnt_log      =     SETTING_INIT_SEND_SMTP_CNT_LOG				# ログ履歴保存数
		self.phase        = int(SETTING_INIT_SEND_SMTP_PHASE)				# プロセスフェーズ
	
	def set_(self, argv):
		
		# 引数カウント
		argv_len     = len(argv) - 1
		print("[INFO____] 引数             : %d" % (argv_len))
		
		# 設定値セット
		self.smtp_server  =     argv[ARGV_NO_SEND_SMTP_SERVER]       if argv_len >= ARGV_NO_SEND_SMTP_SERVER       else     SETTING_INIT_SEND_SMTP_SERVER			# SMTPサーバ
		self.smtp_port    = int(argv[ARGV_NO_SEND_SMTP_PORT])        if argv_len >= ARGV_NO_SEND_SMTP_PORT         else int(SETTING_INIT_SEND_SMTP_PORT)			# SMTPポート
		self.smtp_user    =     argv[ARGV_NO_SEND_SMTP_USER]         if argv_len >= ARGV_NO_SEND_SMTP_USER         else     SETTING_INIT_SEND_SMTP_USER				# SMTPユーザ
		self.smtp_pw      =     argv[ARGV_NO_SEND_SMTP_PW]           if argv_len >= ARGV_NO_SEND_SMTP_PW           else     SETTING_INIT_SEND_SMTP_PW				# SMTPパスワード
		self.smtp_timeout = int(argv[ARGV_NO_SEND_SMTP_TIMEOUT])     if argv_len >= ARGV_NO_SEND_SMTP_TIMEOUT      else int(SETTING_INIT_SEND_SMTP_TIMEOUT)			# SMTPタイムアウト
		self.auth_type    = int(argv[ARGV_NO_SEND_SMTP_AUTH_TYPE])   if argv_len >= ARGV_NO_SEND_SMTP_AUTH_TYPE    else int(SETTING_INIT_SEND_SMTP_AUTH_TYPE)		# 認証方式
		self.from_addr    =     argv[ARGV_NO_SEND_SMTP_FROM_ADDR]    if argv_len >= ARGV_NO_SEND_SMTP_FROM_ADDR    else     SETTING_INIT_SEND_SMTP_FROM_ADDR		# 送信元アドレス
		self.from_name    =     argv[ARGV_NO_SEND_SMTP_FROM_NAME]    if argv_len >= ARGV_NO_SEND_SMTP_FROM_NAME    else     SETTING_INIT_SEND_SMTP_FROM_NAME		# 送信者名
		self.input_path   =     argv[ARGV_NO_SEND_SMTP_INPUT_PATH]   if argv_len >= ARGV_NO_SEND_SMTP_INPUT_PATH   else     SETTING_INIT_SEND_SMTP_INPUT_PATH		# 送信情報入力元
		self.input_encode =     argv[ARGV_NO_SEND_SMTP_INPUT_ENCODE] if argv_len >= ARGV_NO_SEND_SMTP_INPUT_ENCODE else     SETTING_INIT_SEND_SMTP_INPUT_ENCODE		# 送信情報文字コード
		self.output_path  =     argv[ARGV_NO_SEND_SMTP_OUTPUT_PATH]  if argv_len >= ARGV_NO_SEND_SMTP_OUTPUT_PATH  else     SETTING_INIT_SEND_SMTP_OUTPUT_PATH		# 送信情報出力先
		self.dir_log      =     argv[ARGV_NO_SEND_SMTP_DIR_LOG]      if argv_len >= ARGV_NO_SEND_SMTP_DIR_LOG      else     SETTING_INIT_SEND_SMTP_DIR_LOG			# ログ保存先
		self.size_log     = int(argv[ARGV_NO_SEND_SMTP_SIZE_LOG])    if argv_len >= ARGV_NO_SEND_SMTP_SIZE_LOG     else int(SETTING_INIT_SEND_SMTP_SIZE_LOG)		# ログサイズ
		self.cnt_log      = int(argv[ARGV_NO_SEND_SMTP_CNT_LOG])     if argv_len >= ARGV_NO_SEND_SMTP_CNT_LOG      else int(SETTING_INIT_SEND_SMTP_CNT_LOG)			# ログ履歴保存数
		self.phase        = int(argv[ARGV_NO_SEND_SMTP_PHASE])       if argv_len >= ARGV_NO_SEND_SMTP_PHASE        else int(SETTING_INIT_SEND_SMTP_PHASE)			# プロセスフェーズ
	
	def print_(self, argv):
		
		print("[INFO____] SMTPサーバ         : %s" % (self.smtp_server))
		print("[INFO____] SMTPポート         : %d" % (self.smtp_port))
		print("[INFO____] SMTPユーザ         : %s" % (self.smtp_user))
		print("[INFO____] SMTPパスワード     : %s" % (self.smtp_pw))
		print("[INFO____] SMTPタイムアウト   : %d" % (self.smtp_timeout))
		print("[INFO____] 認証方式           : %d" % (self.auth_type))
		print("[INFO____] 送信元アドレス     : %s" % (self.from_addr))
		print("[INFO____] 送信者名           : %s" % (self.from_name))
		print("[INFO____] 送信情報入力元     : %s" % (self.input_path))
		print("[INFO____] 送信情報文字コード : %s" % (self.input_encode))
		print("[INFO____] 送信情報出力先     : %s" % (self.output_path))
		print("[INFO____] ログ保存先         : %s" % (self.dir_log))
		print("[INFO____] ログサイズ         : %d" % (self.size_log))
		print("[INFO____] ログ履歴保存数     : %d" % (self.cnt_log))
		print("[INFO____] プロセスフェーズ   : %d" % (self.phase))

def func_starttls_login_send(setting, status, context):
	
	#
	# TLS通信開始～認証～メール送信関数
	#

	# 初期化
	ret = RET_ERROR_SUCCESS
	
	# TLS通信開始（STARTTLS）
	status = STATUS_SEND_SMTP_START_TLS
	try:
		# EHLO送信
		func_eventlog(LOG_TYPE_DEBUG, format("call function ehlo."))
		smtp.ehlo()
		
		# TLS通信開始
		func_eventlog(LOG_TYPE_DEBUG, format("call function starttls SMTP. (server:%s port:%d)" % (setting.smtp_server, setting.smtp_port)))
		smtp.starttls(context=context)
		
		# SMTP認証
		status = STATUS_SEND_SMTP_LOGIN
		ret = func_smtp_login(setting)
		
		if ret == RET_ERROR_SUCCESS:
			# メール送信
			status = STATUS_SEND_SMTP_SEND_MAIL
			ret, cnt, cnt_err = func_send_mails(setting)
			if (cnt + cnt_err) > 0:
				# ログ出力
				func_eventlog(LOG_TYPE_INFO, format("sent mail SMTP. [cnt:%d err:%d]" % (cnt, cnt_err)))
	
	except:
		# 開始エラー
		ret = RET_ERROR_START_TLS
	
	return ret

def func_smtp_login_send(setting, status):
	
	#
	# 認証～メール送信関数
	#
	
	# 初期化
	ret     = RET_ERROR_SUCCESS
	cnt     = 0
	cnt_err = 0
	
	# SMTP認証
	status = STATUS_SEND_SMTP_LOGIN
	ret = func_smtp_login(setting)
	
	if ret == RET_ERROR_SUCCESS:
		# メール送信
		status = STATUS_SEND_SMTP_SEND_MAIL
		ret, cnt, cnt_err = func_send_mails(setting)
		if (cnt + cnt_err) > 0:
			# ログ出力
			func_eventlog(LOG_TYPE_INFO, format("sent mail SMTP. [cnt:%d err:%d]" % (cnt, cnt_err)))
	
	return ret

def func_smtp_login(setting):
	
	#
	# SMTP認証関数
	#
	
	# 初期化
	ret = RET_ERROR_SUCCESS
	
	
	# SMTP認証-無認証許可対応
	if setting.smtp_user == '' and setting.smtp_pw == '':
		return ret
	
	try:
		# SMTP認証
		func_eventlog(LOG_TYPE_DEBUG, format("call function login SMTP. [srv:%s port:%d]" % (setting.smtp_server, setting.smtp_port)))
		smtp.login(setting.smtp_user, setting.smtp_pw)
	
	except:
		# 認証エラー
		ret = RET_ERROR_LOGIN
		func_eventlog(LOG_TYPE_ERROR, format("failed to login server SMTP. [srv:%s port:%d]" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info()))
	
	return ret

def func_send_mails(setting):
	
	#
	# メール送信関数
	#
	
	# 初期化
	ret         = RET_ERROR_SUCCESS
	cnt_ok      = 0
	cnt_err     = 0
	
	try:
		# 入力ファイルオープン
		func_eventlog(LOG_TYPE_DEBUG, format("open file. [path:%s]" % (setting.input_path)))
		with codecs.open(setting.input_path, 'rb') as file_input:
			
			try:
				if os.path.exists(setting.output_path) == True:
					# 前回の出力ファイル削除
					os.remove(setting.output_path)
				
				# 出力ファイル作成
				func_eventlog(LOG_TYPE_DEBUG, format("create file. [path:%s]" % (setting.output_path)))
				with open(setting.output_path, mode = 'w') as file:
					
					# 現在日時取得
					today_ = datetime.datetime.now()
					
					try:
						# 送信情報取得
						lines = file_input.readlines()
						for cnt in range(len(lines)):
							
							try:
								# デコード処理
								lines[cnt] = lines[cnt].decode(setting.input_encode)
								
								# 送信情報初期化
								mail_no   = 2000
								to_addr   = ""
								subject   = ""
								message   = ""
								file_path = ""
								
								# 送信情報読み込み
								send_data = lines[cnt].split(',', 3)										# カンマ区切り ※件名に含まれるカンマでは分割しないよう最大数を指定
								mail_no   = int(send_data[0])												# メールリスト番号
								to_addr   = send_data[1]													# 宛先アドレス
								file_path = send_data[2]													# 本文ファイル
								subject   = format("[%04d]%s" % (mail_no, send_data[3].replace('\n', '')))	# 件名 ※宛先アドレス先頭のメールリスト番号を付与
								
								# 本文読み込み
								func_eventlog(LOG_TYPE_DEBUG, format("open file. [path:%s]" % (file_path)))
								with codecs.open(file_path, 'rb') as file_msg:
									message = file_msg.read().decode(setting.input_encode)
								
								try:
									# 送信者名チェック
									if setting.from_name != '':
										# 送信者名あり
										from_addr = format("%s<%s>" % (Header(setting.from_name.encode('ISO-2022-JP'), 'ISO-2022-JP').encode(), setting.from_addr))
									else:
										# 送信者名なし
										from_addr = setting.from_addr
									
									# 送信情報セット
									email_msg = MIMEText(message, 'plain')		# 本文
									email_msg['From']    = from_addr			# 送信元アドレス
									email_msg['To']      = to_addr				# 宛先アドレス
									email_msg['Subject'] = subject				# 件名
									
									# メール送信
									smtp.send_message(email_msg)
									func_eventlog(LOG_TYPE_DEBUG, format("sent mail SMTP. [cnt:%d]" % (cnt)))
									
									# 送信情報変換 (CSV形式) ※件名のカンマは削除
									csv_data = format("%04d/%02d/%02d %02d:%02d:%02d,%d,%s,%s,%d\n" % (today_.year, today_.month, today_.day, today_.hour, today_.minute, today_.second,
																									mail_no,
																									to_addr,
																									subject.replace(',', ''),
																									DATA_SEND_ERROR_NONE)
																									)
									
									# 成功件数++
									cnt_ok = cnt_ok + 1
								
								except:
									# 送信エラー
									ret = RET_ERROR_SEND_MAIL
									cnt = cnt - 1
									func_eventlog(LOG_TYPE_ERROR, format("failed to send mail SMTP. [srv:%s port:%d]" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info()))
									
									# 送信情報変換 (CSV形式) ※件名のカンマは削除
									csv_data = format("%04d/%02d/%02d %02d:%02d:%02d,%d,%s,%s,%d\n" % (today_.year, today_.month, today_.day, today_.hour, today_.minute, today_.second,
																									mail_no,
																									to_addr,
																									subject.replace(',', ''),
																									DATA_SEND_ERROR_ERROR)
																									)
									
									# エラー件数++
									cnt_err = cnt_err + 1
							
							except:
								# 本文ファイル読み込みエラー
								ret = RET_ERROR_READ_FILE_MSG
								cnt = cnt - 1
								func_eventlog(LOG_TYPE_ERROR, format("failed to read messages file. [path:%s]" % (file_path)), func_get_exception(sys.exc_info()))
								
								# 送信情報変換 (CSV形式) ※件名のカンマは削除
								csv_data = format("%04d/%02d/%02d %02d:%02d:%02d,%d,%s,%s,%d\n" % (today_.year, today_.month, today_.day, today_.hour, today_.minute, today_.second,
																								mail_no,
																								to_addr,
																								subject.replace(',', ''),
																								DATA_SEND_ERROR_ERROR)
																								)
								
								# エラー件数++
								cnt_err = cnt_err + 1
							
							try:
								# 送信結果ファイル書き込み
								file.write(csv_data)
							
							except:
								# ファイル書き込みエラー
								ret = RET_ERROR_WRITE_FILE
								func_eventlog(LOG_TYPE_ERROR, format("failed to write file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
								break;
					
					except:
						# ファイル読み込みエラー
						ret = RET_ERROR_READ_FILE
						func_eventlog(LOG_TYPE_ERROR, format("failed to read file. [path:%s]" % (setting.input_path)), func_get_exception(sys.exc_info()))
			
			except:
				# ファイル作成エラー
				ret = RET_ERROR_CREATE_FILE
				func_eventlog(LOG_TYPE_ERROR, format("failed to create file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
	
	except:
		# ファイルオープンエラー
		ret = RET_ERROR_CREATE_FILE
		func_eventlog(LOG_TYPE_ERROR, format("failed to open file. [path:%s]" % (setting.input_path)), func_get_exception(sys.exc_info()))
	
	return ret, cnt_ok, cnt_err

#
# メイン処理
#

status = STATUS_SEND_SMTP_INIT

# 初期化
ret = RET_ERROR_SUCCESS

# 設定値取得
setting = cls_setting()
setting.set_(sys.argv)
setting.print_(sys.argv)

# プロセスフェーズ
function.g_phase = setting.phase

# ログファイルオープン
function.g_file_log = func_openlog(setting.dir_log, LOG_PATH_SEND, setting.size_log, setting.cnt_log)

try:
	# SMTP接続
	status = STATUS_SEND_SMTP_CONNECT
	if setting.auth_type == SETTING_DATA_AUTH_TYPE_SSL_TLS:
		
		# SSL/TLS認証
		try:
			# TLSv1.2
			func_eventlog(LOG_TYPE_DEBUG, format("call function SMTP_SSL. [srv:%s, port:%d]" % (setting.smtp_server, setting.smtp_port)))
			context = ssl.create_default_context()
			smtp = smtplib.SMTP_SSL(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout, context=context)
			
			# 認証～メール送信
			ret = func_smtp_login_send(setting, status)
			
			try:
				# SMTP切断
				smtp.quit()
			except:
				# エラー無視 ※サーバ側より切断された場合
				pass
		
		except:
			try:
				# TLSv1.1
				func_eventlog(LOG_TYPE_INFO, format("try to connect server SMTP by TLSv1_1. [srv:%s, port:%d]" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_1)
				smtp = smtplib.SMTP_SSL(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout, context=context)
				
				# 認証～メール送信
				ret = func_smtp_login_send(setting, status)
				
				try:
					# SMTP切断
					smtp.quit()
				except:
					# エラー無視 ※サーバ側より切断された場合
					pass
			
			except:
				# TLSv1.0
				func_eventlog(LOG_TYPE_INFO, format("try to connect server SMTP by TLSv1_0. [srv:%s, port:%d]" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_0)
				smtp = smtplib.SMTP_SSL(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout, context=context)
					
				# 認証～メール送信
				ret = func_smtp_login_send(setting, status)
				
				try:
					# SMTP切断
					smtp.quit()
				except:
					# エラー無視 ※サーバ側より切断された場合
					pass
	
	else:
		if setting.auth_type == SETTING_DATA_AUTH_TYPE_STARTTLS:
			# STARTTLS認証
			status = STATUS_SEND_SMTP_CONNECT
			smtp = smtplib.SMTP(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout)
			
			# TLSv1.2
			func_eventlog(LOG_TYPE_DEBUG, format("call function starttls SMTP. (server:%s port:%d)" % (setting.smtp_server, setting.smtp_port)))
			context = ssl.create_default_context()
			ret = func_starttls_login_send(setting, status, context)
			if ret == RET_ERROR_START_TLS:
				
				# SMTP切断 ※即座に再接続すると例外(Disconnected)が発生するためディレイ時間を設ける
				try:
					smtp.quit()
					time.sleep(5)
				except:
					# エラー無視 ※STARTTLS認証エラー時のRSTにより切断済み
					pass
				
				# SMTP再接続
				status = STATUS_SEND_SMTP_CONNECT
				smtp = smtplib.SMTP(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout)
				
				# TLSv1.1
				func_eventlog(LOG_TYPE_INFO, format("try to starttls SMTP by TLSv1_1. (server:%s port:%d)" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_1)
				ret = func_starttls_login_send(setting, status, context)
				if ret == RET_ERROR_START_TLS:
					
					# SMTP切断 ※即座に再接続すると例外(Disconnected)が発生するためディレイ時間を設ける
					try:
						smtp.quit()
						time.sleep(5)
					except:
						# エラー無視 ※STARTTLS認証エラー時のRSTにより切断済み
						pass
					
					# SMTP再接続
					status = STATUS_SEND_SMTP_CONNECT
					smtp = smtplib.SMTP(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout)
					
					# TLSv1.0
					func_eventlog(LOG_TYPE_INFO, format("try to starttls SMTP by TLSv1_0. (server:%s port:%d)" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
					context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_0)
					ret = func_starttls_login_send(setting, status, context)
					if ret == RET_ERROR_START_TLS:
						# 開始エラー
						func_eventlog(LOG_TYPE_ERROR, format("failed to start TLS SMTP. (server:%s port:%d)" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info()))
			
			try:
				# SMTP切断
				smtp.quit()
			except:
				# エラー無視 ※サーバ側より切断された場合
				pass
		
		else:
			# SSL認証なし
			smtp = smtplib.SMTP(setting.smtp_server, setting.smtp_port, timeout=setting.smtp_timeout)
			
			# 認証～メール送信
			ret = func_smtp_login_send(setting, status)
			
			try:
				# SMTP切断
				smtp.quit()
			except:
				# エラー無視 ※サーバ側より切断された場合
				pass

except:
	# 接続エラー
	ret = RET_ERROR_CONNECT
	func_eventlog(LOG_TYPE_ERROR, format("failed to connect server SMTP. [srv:%s, port:%d]" % (setting.smtp_server, setting.smtp_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))

# ログファイルクローズ
func_closelog(function.g_file_log)

# 終了
exit(ret)
