# coding=UTF-8

#
#  メール受信関数ファイル（POP3方式）
#
#      @package    mail_func_pop3_recv.py
#      @author     M.Suzuki
#      @since      Python 3.6
#      @encode     UTF-8
#

import sys
import ssl
import poplib
import email
import function
from email.header import decode_header, make_header

from all_define   import *					# 定義ファイル
from function     import *					# 共通関数ファイル

class cls_setting:
	
	#
	# 設定値クラス
	#
	
	def __init__(self):
		
		# 初期化
		self.pop3_server   =     SETTING_INIT_RECV_POP3_SERVER			# POP3サーバ
		self.pop3_port     = int(SETTING_INIT_RECV_POP3_PORT)			# POP3ポート
		self.pop3_user     =     SETTING_INIT_RECV_POP3_USER			# POP3ユーザ
		self.pop3_pw       =     SETTING_INIT_RECV_POP3_PW				# POP3パスワード
		self.pop3_timeout  = int(SETTING_INIT_RECV_POP3_TIMEOUT)		# POP3タイムアウト
		self.auth_type     = int(SETTING_INIT_RECV_POP3_AUTH_TYPE)		# 認証方式
		self.max_count     = int(SETTING_INIT_RECV_POP3_MAX_COUNT)		# 受信メール上限数
		self.output_path   =     SETTING_INIT_RECV_POP3_OUTPUT_PATH		# 受信メール出力先
		self.save_days     = int(SETTING_INIT_RECV_POP3_SAVE_DAYS)		# 受信履歴保存期間
		self.dir_recv_hist =     SETTING_INIT_RECV_POP3_DIR_RECV_HIST	# 受信履歴保存先
		self.dir_log       =     SETTING_INIT_RECV_POP3_DIR_LOG			# ログ保存先
		self.size_log      = int(SETTING_INIT_RECV_POP3_SIZE_LOG)		# ログサイズ
		self.cnt_log       = int(SETTING_INIT_RECV_POP3_CNT_LOG)		# ログ履歴保存数
		self.phase         = int(SETTING_INIT_RECV_POP3_PHASE)			# プロセスフェーズ
	
	def set_(self, argv):
		
		# 引数カウント
		argv_len     = len(argv) - 1
		print("[INFO____] 引数             : %d" % (argv_len))
		
		# 設定値セット
		self.pop3_server  =      argv[ARGV_NO_RECV_POP3_SERVER]        if argv_len >= ARGV_NO_RECV_POP3_SERVER        else     SETTING_INIT_RECV_POP3_SERVER			# POP3サーバ
		self.pop3_port     = int(argv[ARGV_NO_RECV_POP3_PORT])         if argv_len >= ARGV_NO_RECV_POP3_PORT          else int(SETTING_INIT_RECV_POP3_PORT)				# POP3ポート
		self.pop3_user     =     argv[ARGV_NO_RECV_POP3_USER]          if argv_len >= ARGV_NO_RECV_POP3_USER          else     SETTING_INIT_RECV_POP3_USER				# POP3ユーザ
		self.pop3_pw       =     argv[ARGV_NO_RECV_POP3_PW]            if argv_len >= ARGV_NO_RECV_POP3_PW            else     SETTING_INIT_RECV_POP3_PW				# POP3パスワード
		self.pop3_timeout  = int(argv[ARGV_NO_RECV_POP3_TIMEOUT])      if argv_len >= ARGV_NO_RECV_POP3_TIMEOUT       else int(SETTING_INIT_RECV_POP3_TIMEOUT)			# POP3タイムアウト
		self.auth_type     = int(argv[ARGV_NO_RECV_POP3_AUTH_TYPE])    if argv_len >= ARGV_NO_RECV_POP3_AUTH_TYPE     else int(SETTING_INIT_RECV_POP3_AUTH_TYPE)		# 認証方式
		self.max_count     = int(argv[ARGV_NO_RECV_POP3_MAX_COUNT])    if argv_len >= ARGV_NO_RECV_POP3_MAX_COUNT     else int(SETTING_INIT_RECV_POP3_MAX_COUNT)		# 受信メール上限数
		self.output_path   =     argv[ARGV_NO_RECV_POP3_OUTPUT_PATH]   if argv_len >= ARGV_NO_RECV_POP3_OUTPUT_PATH   else     SETTING_INIT_RECV_POP3_OUTPUT_PATH		# 受信メール出力先
		self.save_days     = int(argv[ARGV_NO_RECV_POP3_SAVE_DAYS])    if argv_len >= ARGV_NO_RECV_POP3_SAVE_DAYS     else int(SETTING_INIT_RECV_POP3_SAVE_DAYS)		# 受信履歴保存期間
		self.dir_recv_hist =     argv[ARGV_NO_RECV_POP3_DIR_RECV_HIST] if argv_len >= ARGV_NO_RECV_POP3_DIR_RECV_HIST else     SETTING_INIT_RECV_POP3_DIR_RECV_HIST		# 受信履歴保存先
		self.dir_log       =     argv[ARGV_NO_RECV_POP3_DIR_LOG]       if argv_len >= ARGV_NO_RECV_POP3_DIR_LOG       else     SETTING_INIT_RECV_POP3_DIR_LOG			# ログ保存先
		self.size_log      = int(argv[ARGV_NO_RECV_POP3_SIZE_LOG])     if argv_len >= ARGV_NO_RECV_POP3_SIZE_LOG      else int(SETTING_INIT_RECV_POP3_SIZE_LOG)			# ログサイズ
		self.cnt_log       = int(argv[ARGV_NO_RECV_POP3_CNT_LOG])      if argv_len >= ARGV_NO_RECV_POP3_CNT_LOG       else int(SETTING_INIT_RECV_POP3_CNT_LOG)			# ログ履歴保存数
		self.phase         = int(argv[ARGV_NO_RECV_POP3_PHASE])        if argv_len >= ARGV_NO_RECV_POP3_PHASE         else int(SETTING_INIT_RECV_POP3_PHASE)			# プロセスフェーズ
	
	def print_(self, argv):
		
		# 出力
		print("[INFO____] POP3サーバ       : %s" % (self.pop3_server))
		print("[INFO____] POP3ポート       : %d" % (self.pop3_port))
		print("[INFO____] POP3ユーザ       : %s" % (self.pop3_user))
		print("[INFO____] POP3パスワード   : %s" % (self.pop3_pw))
		print("[INFO____] POP3タイムアウト : %d" % (self.pop3_timeout))
		print("[INFO____] 認証方式         : %d" % (self.auth_type))
		print("[INFO____] 受信メール上限数 : %d" % (self.max_count))
		print("[INFO____] 受信メール出力先 : %s" % (self.output_path))
		print("[INFO____] 受信履歴保存期間 : %s" % (self.save_days))
		print("[INFO____] 受信履歴保存先   : %s" % (self.dir_recv_hist))
		print("[INFO____] ログ保存先       : %s" % (self.dir_log))
		print("[INFO____] ログサイズ       : %d" % (self.size_log))
		print("[INFO____] ログ履歴保存数   : %d" % (self.cnt_log))
		print("[INFO____] プロセスフェーズ : %d" % (self.phase))

class cls_recv_info:
	
	#
	# 受信データクラス
	#
	
	def __init__(self):
		
		# 初期化
		self.send_date    = ''		# 送信日時
		self.from_addr    = ''		# 送信者アドレス
		self.to_addr      = ''		# 宛先アドレス
		self.text_subject = ''		# 件名
		self.text_message = ''		# 本文
	
	def set_(self, message):
		
		# 受信データセット
		# 送信日時
		try:
			self.send_date = str(make_header(decode_header(message['Date'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get send datetime."))
		
		# 送信者アドレス
		try:
			self.from_addr = str(make_header(decode_header(message['From'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get send address."))
		
		# 本文 ※内部で例外処理
		self.text_message = func_get_text_message(message)
		
		# 宛先アドレス
		try:
			self.to_addr = str(make_header(decode_header(message['To'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get to address."))
		
		# 件名
		try:
			self.text_subject = str(make_header(decode_header(message['Subject'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get subject."))
	
	def print_(self, cnt):
		
		# 出力
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 受信メール (%d件目)" % (cnt)),                 LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 送信日時       : %s" % (self.send_date)),      LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 送信者アドレス : %s" % (self.from_addr)),      LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 宛先アドレス   : %s" % (self.to_addr)),        LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 件名           : [%s]" % (self.text_subject)), LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 本文           : [%s]" % (self.text_message)), LOG_PATH_RECV)

def func_pop3_login(setting):
	
	#
	# POP3認証関数
	#
	
	# 初期化
	ret = RET_ERROR_SUCCESS
	
	try:
		# POP3認証
		func_eventlog(LOG_TYPE_DEBUG, format("call function login POP3."))
		pop3.user(setting.pop3_user)
		pop3.pass_(setting.pop3_pw)
	
	except:
		# 認証エラー
		ret = RET_ERROR_LOGIN
		func_eventlog(LOG_TYPE_ERROR, format("failed to login server POP3. [srv:%s port:%d]" % (setting.pop3_server, setting.pop3_port)), func_get_exception(sys.exc_info()))
	
	return ret

def func_recv_mail(setting):
	
	#
	# メール受信関数
	#
	
	# 初期化
	ret = RET_ERROR_SUCCESS
	
	try:
		# 受信メール数取得
		recv_cnt = pop3.stat()[0]
		if recv_cnt == 0:
			# 受信メールなし
			ret = RET_ERROR_NO_RECV
			func_eventlog(LOG_TYPE_DEBUG, format("no received mail."))
		else:
			
			try:
				if os.path.exists(setting.output_path) == True:
					# 前回の出力ファイル削除
					os.remove(setting.output_path)
				
				# 出力ファイル作成
				func_eventlog(LOG_TYPE_DEBUG, format("create file. [path:%s]" % (setting.output_path)))
				with open(setting.output_path, mode = 'wb') as file:
					
					try:
						# 現在日時取得
						today_ = datetime.datetime.now()
						
						# 受信メール上限数チェック
						func_eventlog(LOG_TYPE_DEBUG, format("receive mail count. [cnt:%d]" % (recv_cnt)))
						if setting.max_count > 0 and recv_cnt > setting.max_count:
							# 受信メール数を制限
							func_eventlog(LOG_TYPE_DEBUG, format("limit receive mail count. [cnt:%d->%d]" % (recv_cnt, setting.max_count)))
							recv_cnt = setting.max_count
						
						if recv_cnt > 0:
							# 受信メールあり
							# ログ出力
							func_eventlog(LOG_TYPE_INFO, format("received mail. [cnt:%d]" % (recv_cnt)))
							
							# 受信履歴ファイル作成
							file_hist = func_create_file_recv_hist(setting.dir_recv_hist, setting.save_days)
							
							# メール受信（ダウンロード）
							for cnt in range(recv_cnt):
								
								#
								# メールを1件ずつ処理（受信～ファイル書き込み～削除）
								#
								
								# 初期化
								data     = b''
								csv_data = b''
								size     = 0
								
								try:
									# メール受信
									for line in pop3.retr(cnt + 1)[1]:
										data += line + b"\n"
										# 受信サイズチェック
										size = size + len(line)
										if size > DATA_MAX_SIZE_RECV:
											# 受信サイズ上限超過 ※メール破棄
											break
									
									if size > DATA_MAX_SIZE_RECV:
										try:
											# 受信サイズ上限超過
											func_eventlog(LOG_TYPE_ERROR, format("over size by recv mail. [cnt:%d size:%d]" % (cnt, size)))
											
											# 現在日時
											recv_date = format("%04d/%02d/%02d %02d:%02d:%02d" % (today_.year, today_.month, today_.day, today_.hour, today_.minute, today_.second))
											
											# 本文
											text_message = format("over size by recv mail. [cnt:%d size:%d]" % (cnt, size))
											
											# 受信メール履歴
											csv_data = format("%s,,,,,%s,\n" % (recv_date, text_message)).encode(ENCODE_UTF_8, 'ignore')
											func_eventlog(LOG_TYPE_DEBUG, format("write file. [line:%s]" % (csv_data.replace(b'\n', b''))))
											func_write_file_recv_hist(csv_data, file_hist, setting.dir_recv_hist, (setting.cnt_log + 1) * setting.size_log * 1000)
											
											# POP3サーバからメール削除
											func_eventlog(LOG_TYPE_DEBUG, format("deleted mail POP3."))
											pop3.dele(cnt + 1)
										
										except:
											# 削除エラー ※処理は継続
											# ret = RET_ERROR_DELETE_MAIL
											func_eventlog(LOG_TYPE_ERROR, format("failed to delete mail POP3. [srv:%s port:%d]" % (setting.pop3_server, setting.pop3_port)), func_get_exception(sys.exc_info()))
									
									else:
										# デコード
										message = email.message_from_bytes(data)
										
										# 受信情報格納
										recv_info = cls_recv_info()
										recv_info.set_(message)
										recv_info.print_(cnt + 1)
										
										# 受信情報変換 (バイナリ型CSV形式)
										csv_data = func_recv_info_to_csv(today_, recv_info)
										func_eventlog(LOG_TYPE_DEBUG, format("write file. [line:%s]" % (csv_data.replace(b'\n', b''))))
										
										try:
											# 受信メール履歴
											func_write_file_recv_hist(csv_data, file_hist, setting.dir_recv_hist, (setting.cnt_log + 1) * setting.size_log * 1000)
											
											# 受信データ書き込み
											file.write(csv_data)
											
											try:
												# POP3サーバからメール削除
												func_eventlog(LOG_TYPE_DEBUG, format("deleted mail POP3."))
												pop3.dele(cnt + 1)
											
											except:
												# 削除エラー ※処理は継続
												# ret = RET_ERROR_DELETE_MAIL
												func_eventlog(LOG_TYPE_ERROR, format("failed to delete mail POP3. [srv:%s port:%d]" % (setting.pop3_server, setting.pop3_port)), func_get_exception(sys.exc_info()))
										
										except:
											# ファイル書き込みエラー ※次の受信メールを処理
											ret = RET_ERROR_WRITE_FILE
											func_eventlog(LOG_TYPE_ERROR, format("failed to write file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
								
								except:
									# 受信データエラー ※次の受信メールを処理
									ret = RET_ERROR_RECV_TEXT
									func_eventlog(LOG_TYPE_ERROR, format("failed to recv text. [path:%s sbj:%s msg:%s]" % (setting.output_path, recv_info.text_subject, recv_info.text_message)), func_get_exception(sys.exc_info()))
									
									# POP3サーバからメール削除
									func_eventlog(LOG_TYPE_DEBUG, format("deleted mail POP3."))
									pop3.dele(cnt + 1)
					
					except:
						# 受信エラー
						ret = RET_ERROR_RECV_MAIL
						func_eventlog(LOG_TYPE_ERROR, format("failed to recv mail POP3. [srv:%s port:%d]" % (setting.pop3_server, setting.pop3_port)), func_get_exception(sys.exc_info()))
			
			except:
				# ファイル作成エラー
				ret = RET_ERROR_CREATE_FILE
				func_eventlog(LOG_TYPE_ERROR, format("failed to create file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
		
	except:
		# 受信数取得エラー
		ret = RET_ERROR_GET_MAIL_COUNT
		func_eventlog(LOG_TYPE_ERROR, format("failed to get mail count POP3. [srv:%s port:%d]" % (setting.pop3_server, setting.pop3_port)), func_get_exception(sys.exc_info()))
	
	return ret

#
# メイン処理
#

status = STATUS_RECV_POP3_INIT

# 初期化
ret    = RET_ERROR_SUCCESS

# 設定値取得
setting = cls_setting()
setting.set_(sys.argv)
setting.print_(sys.argv)

# プロセスフェーズ
function.g_phase = setting.phase

# ログファイルオープン
function.g_file_log = func_openlog(setting.dir_log, LOG_PATH_RECV, setting.size_log, setting.cnt_log)

try:
	# POP3接続
	status = STATUS_RECV_POP3_CONNECT
	if setting.auth_type == SETTING_DATA_AUTH_TYPE_SSL_TLS:
		
		# SSL/TLS認証
		try:
			# TLSv1.2
			func_eventlog(LOG_TYPE_DEBUG, format("call function POP3_SSL. [srv:%s, port:%d, timeout:%d]" % (setting.pop3_server, setting.pop3_port, setting.pop3_timeout)))
			context = ssl.create_default_context()
			pop3 = poplib.POP3_SSL(setting.pop3_server, setting.pop3_port, timeout=setting.pop3_timeout, context=context)
		
		except:
			try:
				# TLSv1.1
				func_eventlog(LOG_TYPE_INFO, format("try to connect server POP3 by TLSv1_1. [srv:%s, port:%d, timeout:%d]" % (setting.pop3_server, setting.pop3_port, setting.pop3_timeout)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_1)
				pop3 = poplib.POP3_SSL(setting.pop3_server, setting.pop3_port, timeout=setting.pop3_timeout, context=context)
			
			except:
				# TLSv1.0
				func_eventlog(LOG_TYPE_INFO, format("try to connect server POP3 by TLSv1_0. [srv:%s, port:%d, timeout:%d]" % (setting.pop3_server, setting.pop3_port, setting.pop3_timeout)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1)
				pop3 = poplib.POP3_SSL(setting.pop3_server, setting.pop3_port, timeout=setting.pop3_timeout, context=context)
	
	else:
		# 認証なし
		func_eventlog(LOG_TYPE_DEBUG, format("call function POP3. [srv:%s, port:%d, timeout:%d]" % (setting.pop3_server, setting.pop3_port, setting.pop3_timeout)))
		pop3 = poplib.POP3(setting.pop3_server, setting.pop3_port, timeout=setting.pop3_timeout)
	
	if ret == RET_ERROR_SUCCESS:
		# POP3認証
		status = STATUS_RECV_POP3_LOGIN
		ret = func_pop3_login(setting)
		
	if ret == RET_ERROR_SUCCESS:
		# メール受信
		status = STATUS_RECV_POP3_RECV_MAIL
		ret = func_recv_mail(setting)
	
	try:
		# POP3切断
		pop3.quit()
	except:
		# エラー無視  ※サーバ側より切断された場合
		pass

except:
	# 接続エラー
	ret = RET_ERROR_CONNECT
	func_eventlog(LOG_TYPE_ERROR, format("failed to connect server POP3. [srv:%s, port:%d, timeout:%d]" % (setting.pop3_server, setting.pop3_port, setting.pop3_timeout)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))

# ログファイルクローズ
func_closelog(function.g_file_log)

# 終了
exit(ret)
