# coding=UTF-8

#
#  メール受信関数ファイル（IMAP方式）
#
#      @package    mail_func_imap_recv.py
#      @author     M.Suzuki
#      @since      Python 3.6
#      @encode     UTF-8
#

import sys
import ssl
import imaplib
import email
import function
from email.header import decode_header, make_header

from all_define   import *					# 定義ファイル
from function     import *					# 共通関数ファイル

class cls_setting:
	
	#
	# 設定値クラス
	#
	
	def __init__(self):
		
		# 初期化
		self.imap_server   =     SETTING_INIT_RECV_IMAP_SERVER				# IMAPサーバ
		self.imap_port     = int(SETTING_INIT_RECV_IMAP_PORT)				# IMAPポート
		self.imap_user     =     SETTING_INIT_RECV_IMAP_USER				# IMAPユーザ
		self.imap_pw       =     SETTING_INIT_RECV_IMAP_PW					# IMAPパスワード
		self.auth_type     = int(SETTING_INIT_RECV_IMAP_AUTH_TYPE)			# 認証方式
		self.max_count     = int(SETTING_INIT_RECV_IMAP_MAX_COUNT)			# 受信メール上限数
		self.search_key    =     SETTING_INIT_RECV_IMAP_SEARCH_KEY			# 受信検索キー
		self.output_path   =     SETTING_INIT_RECV_IMAP_OUTPUT_PATH			# 受信情報出力先
		self.save_days     = int(SETTING_INIT_RECV_IMAP_SAVE_DAYS)			# 受信履歴保存期間
		self.dir_recv_hist =     SETTING_INIT_RECV_IMAP_DIR_RECV_HIST		# 受信履歴保存先
		self.dir_log       =     SETTING_INIT_RECV_IMAP_DIR_LOG				# ログ保存先
		self.size_log      = int(SETTING_INIT_RECV_IMAP_SIZE_LOG)			# ログサイズ
		self.cnt_log       = int(SETTING_INIT_RECV_IMAP_CNT_LOG)			# ログ履歴保存数
		self.phase         = int(SETTING_INIT_RECV_IMAP_PHASE)				# プロセスフェーズ
	
	def set_(self, argv):
		
		# 引数カウント
		argv_len     = len(argv) - 1
		print("[INFO____] 引数             : %d" % (argv_len))
		
		# 設定値セット
		self.imap_server   =     argv[ARGV_NO_RECV_IMAP_SERVER]        if argv_len >= ARGV_NO_RECV_IMAP_SERVER        else     SETTING_INIT_RECV_IMAP_SERVER			# IMAPサーバ
		self.imap_port     = int(argv[ARGV_NO_RECV_IMAP_PORT])         if argv_len >= ARGV_NO_RECV_IMAP_PORT          else int(SETTING_INIT_RECV_IMAP_PORT)				# IMAPポート
		self.imap_user     =     argv[ARGV_NO_RECV_IMAP_USER]          if argv_len >= ARGV_NO_RECV_IMAP_USER          else     SETTING_INIT_RECV_IMAP_USER				# IMAPユーザ
		self.imap_pw       =     argv[ARGV_NO_RECV_IMAP_PW]            if argv_len >= ARGV_NO_RECV_IMAP_PW            else     SETTING_INIT_RECV_IMAP_PW				# IMAPパスワード
		self.auth_type     = int(argv[ARGV_NO_RECV_IMAP_AUTH_TYPE])    if argv_len >= ARGV_NO_RECV_IMAP_AUTH_TYPE     else int(SETTING_INIT_RECV_IMAP_AUTH_TYPE)		# 認証方式
		self.max_count     = int(argv[ARGV_NO_RECV_IMAP_MAX_COUNT])    if argv_len >= ARGV_NO_RECV_IMAP_MAX_COUNT     else int(SETTING_INIT_RECV_IMAP_MAX_COUNT)		# 受信メール上限数
		self.search_key    =     argv[ARGV_NO_RECV_IMAP_SEARCH_KEY]    if argv_len >= ARGV_NO_RECV_IMAP_SEARCH_KEY    else     SETTING_INIT_RECV_IMAP_SEARCH_KEY		# 受信検索キー
		self.output_path   =     argv[ARGV_NO_RECV_IMAP_OUTPUT_PATH]   if argv_len >= ARGV_NO_RECV_IMAP_OUTPUT_PATH   else     SETTING_INIT_RECV_IMAP_OUTPUT_PATH		# 受信情報出力先
		self.save_days     = int(argv[ARGV_NO_RECV_IMAP_SAVE_DAYS])    if argv_len >= ARGV_NO_RECV_IMAP_SAVE_DAYS     else int(SETTING_INIT_RECV_IMAP_SAVE_DAYS)		# 受信履歴保存期間
		self.dir_recv_hist =     argv[ARGV_NO_RECV_IMAP_DIR_RECV_HIST] if argv_len >= ARGV_NO_RECV_IMAP_DIR_RECV_HIST else     SETTING_INIT_RECV_IMAP_DIR_RECV_HIST		# 受信履歴保存先
		self.dir_log       =     argv[ARGV_NO_RECV_IMAP_DIR_LOG]       if argv_len >= ARGV_NO_RECV_IMAP_DIR_LOG       else     SETTING_INIT_RECV_IMAP_DIR_LOG			# ログ保存先
		self.size_log      = int(argv[ARGV_NO_RECV_IMAP_SIZE_LOG])     if argv_len >= ARGV_NO_RECV_IMAP_SIZE_LOG      else int(SETTING_INIT_RECV_IMAP_SIZE_LOG)			# ログサイズ
		self.cnt_log       = int(argv[ARGV_NO_RECV_IMAP_CNT_LOG])      if argv_len >= ARGV_NO_RECV_IMAP_CNT_LOG       else int(SETTING_INIT_RECV_IMAP_CNT_LOG)			# ログ履歴保存数
		self.phase         = int(argv[ARGV_NO_RECV_IMAP_PHASE])        if argv_len >= ARGV_NO_RECV_IMAP_PHASE         else int(SETTING_INIT_RECV_IMAP_PHASE)			# プロセスフェーズ
		
		# 受信検索キーを配列化
		self.tbl_search_keys = self.search_key.split(',')
	
	def print_(self, argv):
		
		# 出力
		print("[INFO____] IMAPサーバ       : %s" % (self.imap_server))
		print("[INFO____] IMAPポート       : %d" % (self.imap_port))
		print("[INFO____] IMAPユーザ       : %s" % (self.imap_user))
		print("[INFO____] IMAPパスワード   : %s" % (self.imap_pw))
		print("[INFO____] 認証方式         : %d" % (self.auth_type))
		print("[INFO____] 受信メール上限数 : %d" % (self.max_count))
		for num in range(len(self.tbl_search_keys)):
			print("[INFO____] 受信検索キー[%02d] : %s" % (num, self.tbl_search_keys[num]))
		print("[INFO____] 受信情報出力先   : %s" % (self.output_path))
		print("[INFO____] 受信履歴保存期間 : %d" % (self.save_days))
		print("[INFO____] 受信履歴保存先   : %s" % (self.dir_recv_hist))
		print("[INFO____] ログ保存先       : %s" % (self.dir_log))
		print("[INFO____] ログサイズ       : %d" % (self.size_log))
		print("[INFO____] ログ履歴保存数   : %d" % (self.cnt_log))
		print("[INFO____] プロセスフェーズ : %d" % (self.phase))

class cls_recv_info:
	
	#
	# 受信データクラス
	#
	
	def __init__(self):
		
		# 初期化
		self.send_date    = ''		# 送信日時
		self.from_addr    = ''		# 送信者アドレス
		self.to_addr      = ''		# 宛先アドレス
		self.text_subject = ''		# 件名
		self.text_message = ''		# 本文
	
	def set_(self, message):
		
		# 受信データセット
		# 送信日時
		try:
			self.send_date = str(make_header(decode_header(message['Date'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get send datetime."))
		
		# 送信者アドレス
		try:
			self.from_addr = str(make_header(decode_header(message['From'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get send address."))
		
		# 本文 ※内部で例外処理
		self.text_message = func_get_text_message(message)
		
		# 宛先アドレス
		try:
			self.to_addr = str(make_header(decode_header(message['To'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get to address."))
		
		# 件名
		try:
			self.text_subject = str(make_header(decode_header(message['Subject'])))
		except:
			# ※処理は継続
			func_eventlog(LOG_TYPE_ERROR, format("failed to get subject."))
	
	def print_(self, cnt):
		
		# 出力
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 受信メール (%d件目)" % (cnt)),                 LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 送信日時       : %s" % (self.send_date)),      LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 送信者アドレス : %s" % (self.from_addr)),      LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 宛先アドレス   : %s" % (self.to_addr)),        LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 件名           : [%s]" % (self.text_subject)), LOG_PATH_RECV)
		func_eventlog(LOG_TYPE_DEBUG, format("[INFO____] 本文           : [%s]" % (self.text_message)), LOG_PATH_RECV)

def func_imap_login_recv(status):
	
	#
	# 認証～メール受信関数
	#
	
	# 初期化
	ret = RET_ERROR_SUCCESS
	
	# IMAP認証
	status = STATUS_RECV_IMAP_LOGIN
	ret = func_imap_login(setting)
	
	if ret == RET_ERROR_SUCCESS:
		# メール受信
		status = STATUS_RECV_IMAP_RECV_MAIL
		ret = func_recv_mail(setting)
	
	return ret

def func_imap_login(setting):
	
	#
	# IMAP認証関数
	#
	
	# 初期化
	ret = RET_ERROR_SUCCESS
	
	try:
		# IMAP認証
		func_eventlog(LOG_TYPE_DEBUG, format("call function login IMAP."))
		imap.login(setting.imap_user, setting.imap_pw)
	
	except:
		# 認証エラー
		ret = RET_ERROR_LOGIN
		func_eventlog(LOG_TYPE_ERROR, format("failed to login server IMAP. [srv:%s port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info()))
	
	return ret

def func_recv_mail(setting):
	
	#
	# メール受信関数
	#
	
	# 初期化
	ret      = RET_ERROR_SUCCESS
	recv_cnt = 0
	
	try:
		if os.path.exists(setting.output_path) == True:
			# 前回の出力ファイル削除
			os.remove(setting.output_path)
		
		# 出力ファイル作成
		func_eventlog(LOG_TYPE_DEBUG, format("create file. [path:%s]" % (setting.output_path)))
		with open(setting.output_path, mode = 'wb') as file:
			
			try:
				# 現在日時取得
				today_ = datetime.datetime.now()
				
				# 受信フォルダ指定 ※既読を付けるために書き込み許可
				imap.select(mailbox='INBOX', readonly=False)
				
				# 受信検索キー整列（スペース区切り）
				search_keys = ''
				table_len   = len(setting.tbl_search_keys)
				for num in range(table_len):
					search_keys += setting.tbl_search_keys[num]
					if num < (table_len - 1):
						# 末尾でない
						search_keys += " "
				
				# 受信メール取得
				_, data = imap.search(None, search_keys)
				
				# 受信メール解析
				mails = data[0].split()
				if len(mails) == 0:
					# 受信メールなし
					ret = RET_ERROR_NO_RECV
					func_eventlog(LOG_TYPE_DEBUG, format("no received mail."))
				
				else:
					# 受信メール上限数チェック
					recv_cnt = len(mails)
					func_eventlog(LOG_TYPE_DEBUG, format("receive mail count. [cnt:%d]" % (recv_cnt)))
					if setting.max_count > 0 and recv_cnt > setting.max_count:
						# 受信メール数を制限
						func_eventlog(LOG_TYPE_DEBUG, format("limit receive mail count. [cnt:%d->%d]" % (recv_cnt, setting.max_count)))
						recv_cnt = setting.max_count
					
					if recv_cnt > 0:
						# 受信メールあり
						# ログ出力
						func_eventlog(LOG_TYPE_INFO, format("received mail. [cnt:%d]" % (recv_cnt)))
						
						# 受信履歴ファイル作成
						file_hist = func_create_file_recv_hist(setting.dir_recv_hist, setting.save_days)
						
						# メール受信（参照）
						for cnt in range(recv_cnt):
							
							#
							# メールを1件ずつ処理（受信～ファイル書き込み～既読フラグ変更）
							#
							
							try: 
								# メール受信
								_, data = imap.fetch(mails[cnt], '(RFC822)')
								message = email.message_from_bytes(data[0][1])		# デコード
								
								# 受信情報格納
								recv_info = cls_recv_info()
								recv_info.set_(message)
								recv_info.print_(cnt + 1)
								
								# 受信情報変換 (バイナリ型CSV形式)
								csv_data = func_recv_info_to_csv(today_, recv_info)
								func_eventlog(LOG_TYPE_DEBUG, format("write file. [path:%s]" % (setting.output_path)))
								
								try:
									# 受信履歴書き込み
									func_write_file_recv_hist(csv_data, file_hist, setting.dir_recv_hist, (setting.cnt_log + 1) * setting.size_log * 1000)
									
									# 回答結果ファイル書き込み
									file.write(csv_data)
									
									try:
										# 既読フラグ有効
										func_eventlog(LOG_TYPE_DEBUG, format("seen reserved mail IMAP."))
										imap.store(mails[cnt], '+FLAGS', '\\Seen')
									
									except:
										# 既読フラグ有効化エラー ※処理は継続
										# ret = RET_ERROR_DELETE_MAIL
										func_eventlog(LOG_TYPE_ERROR, format("failed to change flag IMAP by seen. [srv:%s port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info()))
									
									try:
										# 削除フラグ有効
										func_eventlog(LOG_TYPE_DEBUG, format("delete reserved mail IMAP."))
										imap.store(mails[cnt], '+FLAGS', '\\Deleted')
									
									except:
										# 削除フラグ有効化エラー ※処理は継続
										# ret = RET_ERROR_DELETE_MAIL
										func_eventlog(LOG_TYPE_ERROR, format("failed to change flag IMAP by deleted. [srv:%s port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info()))
								
								except:
									# ファイル書き込みエラー ※次の受信メールを処理
									ret = RET_ERROR_WRITE_FILE
									func_eventlog(LOG_TYPE_ERROR, format("failed to write file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
							
							except:
								# 受信データエラー ※次の受信メールを処理
								ret = RET_ERROR_RECV_TEXT
								func_eventlog(LOG_TYPE_ERROR, format("failed to recv text. [path:%s sbj:%s msg:%s]" % (setting.output_path, recv_info.text_subject, recv_info.text_message)), func_get_exception(sys.exc_info()))
								
								# 削除フラグ有効
								ret = RET_ERROR_SUCCESS
								func_eventlog(LOG_TYPE_ERROR, format("delete reserved mail IMAP by limit recv count. [limit:%d]" % (recv_cnt)))
								imap.store(mails[cnt], '+FLAGS', '\\Deleted')
			
			except:
				# 受信エラー
				ret = RET_ERROR_RECV_MAIL
				func_eventlog(LOG_TYPE_ERROR, format("failed to recv mail IMAP. [srv:%s port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info()))
	
	except:
		# ファイル作成エラー
		ret = RET_ERROR_CREATE_FILE
		func_eventlog(LOG_TYPE_ERROR, format("failed to create file. [path:%s]" % (setting.output_path)), func_get_exception(sys.exc_info()))
	
	if recv_cnt > 0:
		# 受信メールあり
		try:
			# メール削除フラグ反映
			imap.expunge()
		
		except:
			# フラグ反映エラー ※処理は継続
			# ret = RET_ERROR_DELETE_MAIL
			func_eventlog(LOG_TYPE_ERROR, format("failed to deleted mail IMAP. [srv:%s port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info()))
	
	return ret

#
# メイン処理
#

status = STATUS_RECV_IMAP_INIT

# 初期化
ret    = RET_ERROR_SUCCESS

# 設定値取得
setting = cls_setting()
setting.set_(sys.argv)
setting.print_(sys.argv)

# プロセスフェーズ
function.g_phase = setting.phase

# ログファイルオープン
function.g_file_log = func_openlog(setting.dir_log, LOG_PATH_RECV, setting.size_log, setting.cnt_log)

try:
	# IMAP接続
	status = STATUS_RECV_IMAP_CONNECT
	if setting.auth_type == SETTING_DATA_AUTH_TYPE_SSL_TLS:
		
		# SSL/TLS認証
		try:
			# TLSv1.2
			func_eventlog(LOG_TYPE_DEBUG, format("call function IMAP4_SSL. [srv:%s, port:%d]" % (setting.imap_server, setting.imap_port)))
			context = ssl.create_default_context()
			with imaplib.IMAP4_SSL(setting.imap_server, setting.imap_port, ssl_context=context) as imap:
				
				# 認証～メール受信
				ret = func_imap_login_recv(status)
		
		except:
			try:
				# TLSv1.1
				func_eventlog(LOG_TYPE_INFO, format("try to connect server IMAP by TLSv1_1. [srv:%s, port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_1)
				with imaplib.IMAP4_SSL(setting.imap_server, setting.imap_port, ssl_context=context) as imap:
					
					# 認証～メール受信
					ret = func_imap_login_recv(status)
			
			except:
				# TLSv1.0
				func_eventlog(LOG_TYPE_INFO, format("try to connect server IMAP by TLSv1_0. [srv:%s, port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))
				context = ssl.SSLContext(ssl.PROTOCOL_TLSv1_0)
				with imaplib.IMAP4_SSL(setting.imap_server, setting.imap_port, ssl_context=context) as imap:
					
					# 認証～メール受信
					ret = func_imap_login_recv(status)
	
	else:
		
		# 認証なし
		func_eventlog(LOG_TYPE_DEBUG, format("call function IMAP4. [srv:%s, port:%d]" % (setting.imap_server, setting.imap_port)))
		with imaplib.IMAP4(setting.imap_server, setting.imap_port) as imap:
			
			# 認証～メール受信
			ret = func_imap_login_recv(status)

except:
	# 接続エラー
	ret = RET_ERROR_CONNECT
	func_eventlog(LOG_TYPE_ERROR, format("failed to connect server IMAP. [srv:%s, port:%d]" % (setting.imap_server, setting.imap_port)), func_get_exception(sys.exc_info(), DATA_EXCEPT_DETAIL))

# ログファイルクローズ
func_closelog(function.g_file_log)

# 終了
exit(ret)
