# coding=UTF-8

#
#  共通関数ファイル
#
#      @package    function.py
#      @author     M.Suzuki
#      @since      Python 3.6
#      @encode     UTF-8
#

import sys
import os
import datetime
import base64

from all_define   import *					# 定義ファイル

# グローバル変数
global g_file_log
global g_phase

#
# 汎用
#

def func_get_exception(exc_info, limit = DATA_EXCEPT_MIN):
	
	#
	# 例外メッセージ取得関数
	#
	
	# 初期化
	exc_msg = ''
	info_no = 0
	
	# 指定番号まで例外を出力 ※2つめ以降の情報にはメールアドレスが含まれる場合があるため注意
	for info_no in range(limit):
		exc_msg += format("%s %s " % (str(exc_info[info_no]), str(type(exc_info[info_no]))))
	
	return exc_msg

def func_openlog(dir, fname, max_size, max_cnt):

	#
	# ログファイルオープン関数
	#

	# 初期化
	file    = None
	path    = dir + "/" + fname
	ext_str = ''
	
	try:
		if dir != '':
			# ファイルサイズチェック
			if os.path.getsize(path) >= max_size * 1000:
				# サイズ超過
				# 保存数超過分を削除
				files = os.listdir(dir)
				for file in files:
					if os.path.isfile(dir + "/" + file) == True:
						try:
							# ファイル名チェック
							ext_str = file.split(fname)[1]
							if ext_str != '':
								num = int(ext_str.replace('.', ''))
								if num >= max_cnt:
									# 削除
									os.remove(dir + "/" + file)
						
						except:
							# 対象外ファイル
							pass
				
				# サイクリック
				for cnt in range(max_cnt, 0, -1):
					if cnt > 1:
						src_path = format(FMT_FNAME_LOG_HST % (path, cnt - 1))
					else:
						src_path = path
					
					if os.path.exists(src_path) == True:
						# ファイル名変更
						os.rename(src_path, format(FMT_FNAME_LOG_HST % (path, cnt)))
	
	except:
		# サイクリックエラー ※処理は継続
		print("[ERROR___] error cycle log (%s, %s)" % (dir, fname))

	try:
		# ログファイルオープン
		file = open(path, mode = 'a')
	
	except:
		# オープンエラー
		file = None
		print("[ERROR___] error open log (%s, %s)" % (dir, fname))

	return file

def func_closelog(file):

	#
	# ログファイルクローズ関数
	#

	try:
		if file != None:
			# ログファイルクローズ
			file.close()
			file = None

	except:
		# クローズエラー
		print("[ERROR___] error close log")

	return file

def func_eventlog(type, message, exc_msg = ''):
	
	#
	# ログ出力関数
	#
	
	try:
		# ログ書式化
		text = func_format_log(datetime.datetime.now(), type, message, exc_msg)
		
		# ファイル出力
		if g_file_log != None:
			if (type != LOG_TYPE_DEBUG) or (type == LOG_TYPE_DEBUG and g_phase >= PHASE_DATA_DEBUG):
				# ログ書き込み
				g_file_log.write(format("%s\n" % (text)))
		
		# 画面出力 ※デバッグ用
		print(text)
		
	except:
		# エラー
		print("[ERROR___] error write log (%s, %s)" % (type, message))

def func_format_log(datetime, type, message, exc_msg):
	
	#
	# ログ書式化（YYYY/MM/DD hh:mm:ss.nnn type: message (note1, note2) <exc_msg>）
	#
	
	# 日時 + プロセスID(固定値) + スレッドID(固定値) + 種別 + 内容
	text = format("%04d/%02d/%02d %02d:%02d:%02d.%03d,%d,0x%08x,%s,%s" % (datetime.year, datetime.month, datetime.day, datetime.hour, datetime.minute, datetime.second, int(datetime.microsecond / 1000), LOG_DATA_PRO_ID, LOG_DATA_THR_ID, type, message))
	
	# 例外情報
	if exc_msg != '':
		text += format(" <%s>" % (exc_msg))
	
	return text

#
# 日時関連
#

class cls_systemtime:
	
	#
	# 日時クラス
	#
	
	def __init__(self):
		
		# 初期化
		self.year   = int(DATETIME_YEAR_INIT)
		self.month  = int(DATETIME_MONTH_INIT)
		self.day    = int(DATETIME_DAY_INIT)
		# self.week = int(DATETIME_WEEK_INIT)
		self.hour   = int(DATETIME_HOUR_INIT)
		self.minute = int(DATETIME_MINUTE_INIT)
		self.second = int(DATETIME_SECOND_INIT)
	
	def print_(self):
		func_eventlog(LOG_TYPE_DEBUG, format("datetime. (tm=%04d/%02d/%02d %02d:%02d:%02d)" % (self.year, self.month, self.day, self.hour, self.minute, self.second)))
	
	def conv_datetime(self):
		
		# datetime形に変換
		return datetime.datetime(self.year, self.month, self.day, self.hour, self.minute, self.second)

def func_conv_datetime_from_UKformat(from_datetime, local_jpn = True):
	
	#
	# 日時形式変換（イギリス表記 [www DD MMM YYY hh:mm:ss +nnnn] → 日本表記 [YYYY/MM/DD hh:mm:ss]）
	#
	
	tbl_months = ['jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec']
	
	# 初期化
	systemtime = cls_systemtime()
	time_diff_hh = TIMEDIFF_JAPAN_HOUR
	time_diff_mm = TIMEDIFF_JAPAN_MINUTE
	
	try:
		# 要素分割（曜日、日、月、年、時刻、標準時刻差）
		tbl_datetimes = from_datetime.replace('-', ' ').replace('/', ' ').split(' ')
		
		# 要素チェック
		for item in tbl_datetimes:
			
			if item.isdecimal() == True and len(item) == 4:
				# 年 ※数値のみ4桁
				systemtime.year = int(item)
				continue
			
			if item.isdecimal() == True and len(item) == 2:
				# 日 ※数値のみ2桁
				systemtime.day = int(item)
				continue
			
			if ':' in item:
				# 時分秒 ※":"含む
				tbl_times = item.split(':')
				systemtime.hour   = int(tbl_times[0])		# 時
				systemtime.minute = int(tbl_times[1])		# 分
				systemtime.second = int(tbl_times[2])		# 秒
				continue
			
			if (item.startswith('+') or item.startswith('-')) and item[1:4].isdecimal() == True:
				# 標準時刻差 ※先頭"+"or"-"、かつ数値のみ4桁
				if item.startswith('+'):
					# "+nnnn"
					time_diff = datetime.timedelta(hours=(TIMEDIFF_JAPAN_HOUR - int(item[1:3])), minutes=(TIMEDIFF_JAPAN_MINUTE - int(item[3:5])))
				else:
					# "-nnnn"
					time_diff = datetime.timedelta(hours=(TIMEDIFF_JAPAN_HOUR + int(item[1:3])), minutes=(TIMEDIFF_JAPAN_MINUTE + int(item[3:5])))
				continue
			
			# 月
			for num in range(len(tbl_months)):
				if item.lower().startswith(tbl_months[num]) == True:
					# 先頭文字一致
					systemtime.month = num + 1
					break
		
		# datetime型に変換
		dt_ = systemtime.conv_datetime()
		if local_jpn == True:
			# 日本標準時に補正
			dt_ += time_diff
		
		# 日本表記に変換
		to_datetime = format("%04d/%02d/%02d %02d:%02d:%02d" % (dt_.year, dt_.month, dt_.day, dt_.hour, dt_.minute, dt_.second))
		func_eventlog(LOG_TYPE_DEBUG, format("change datetime format. (%s->%s)" % (from_datetime, to_datetime)))
		
	except:
		# 変換エラー ※元の表記をそのまま返す
		func_eventlog(LOG_TYPE_ERROR, format("error convert datetime. (%s)" % (from_datetime)), func_get_exception(sys.exc_info()))
		to_datetime = from_datetime
	
	return to_datetime

def func_get_weekday(datetime):
	
	tbl_week = [WEEK_MON, WEEK_THU, WEEK_WED, WEEK_THU, WEEK_FRI, WEEK_STA]
	
	# 日付から曜日取得
	weekday = datetime.date(self.year, self.month, self.day).weekday()
	
	# 0=日曜～6=土に変換してセット ※SYSTEMTIME型に準拠
	return tbl_week[weekday]

#
# メール関連
#

def func_recv_info_to_csv(today_, recv_data = None, exc_info = None):
	
	#
	# 受信情報変換関数 (バイナリ型CSV形式)
	#
	
	# 初期化
	line         = b''
	lines        = []
	recv_date    = ''
	send_date    = ''
	from_addr    = ''
	to_addr      = ''
	text_subject = ''
	text_message = ''
	
	# 情報配列化 ※カンマ・改行削除
	if recv_data != None:
		recv_date    = format("%04d/%02d/%02d %02d:%02d:%02d" % (today_.year, today_.month, today_.day, today_.hour, today_.minute, today_.second))		# 現在日時
		send_date    = func_conv_datetime_from_UKformat(recv_data.send_date).replace(',', '').replace('\n', '')											# 受信データ	：送信日時（日本表記）
		from_addr    = str(recv_data.from_addr).replace(',', '').replace('\n', '')																		#				：送信者アドレス
		to_addr      = str(recv_data.to_addr).replace(',', '').replace('\n', '')																		#				：宛先アドレス
		text_subject = str(recv_data.text_subject).replace(',', '').replace('\n', '')																	#				：件名
		text_message = str(recv_data.text_message).replace(',', '').replace('\n', '')																	#				：本文 (UTF-8)
		
		# バイナリ型へ変換 ※文字コードが混在するため
		lines.insert(FILE_COL_RECV_RECV_DATE,        recv_date.encode(ENCODE_UTF_8,     'ignore'))
		lines.insert(FILE_COL_RECV_SEND_DATE,        send_date.encode(ENCODE_UTF_8,     'ignore'))
		lines.insert(FILE_COL_RECV_FROM_ADDR,        from_addr.encode(ENCODE_UTF_8,     'ignore'))
		lines.insert(FILE_COL_RECV_TO_ADDR,          to_addr.encode(ENCODE_UTF_8,       'ignore'))
		lines.insert(FILE_COL_RECV_TEXT_SUBJECT,     text_subject.encode(ENCODE_UTF_8,  'ignore'))
		lines.insert(FILE_COL_RECV_TEXT_MESSAGE,     text_message.encode(ENCODE_UTF_8,  'ignore'))
		lines.insert(FILE_COL_RECV_TEXT_MESSAGE_EUC, text_message.encode(ENCODE_EUC_JP, 'ignore')) # ※LANマニュアル通知用の文字コード
	
	# 配列 → CSV形式
	col_cnt = len(lines)
	for col in range(col_cnt):
		line += lines[col]
		if col < (col_cnt - 1):
			# 末尾でない
			line += b','
		else:
			#末尾に改行
			line += b'\n'
	
	return line

def func_decode_from_base64(from_str):
	
	#
	# base64デコード関数
	#
	
	try:
		# base64デコード
		to_str = base64.b64decode(from_str).decode()
		func_eventlog(LOG_TYPE_DEBUG, format("base64 decoded. (%s)") % (to_str))
	
	except:
		# デコードエラー ※元の文字列をそのまま返す
		to_str = from_str
	
	return to_str

def func_get_text_message(message):
	
	#
	# 本文取得関数
	#
	
	try:
		# 本文取得
		if message.is_multipart() == False:
			# single part
			func_eventlog(LOG_TYPE_DEBUG, format("received mail payload. (part=single)"))
			payload = message.get_payload(decode=True)
			
			# 文字コードチェック
			charset = message.get_content_charset()
			if charset != None:
				# デコード
				payload = payload.decode(charset, "ignore")
				func_eventlog(LOG_TYPE_DEBUG, format("%s decoded." % (charset)))
			
			# base64デコード
			lines = func_decode_from_base64(payload)
		
		else:
			# multi part
			func_eventlog(LOG_TYPE_DEBUG, format("received mail payload. (part=multi)"))
			for part in message.walk():
				payload = part.get_payload(decode=True)
				if payload == None:
					continue
				
				# 添付ファイルチェック
				fname = part.get_filename()
				if fname != None:
					# 添付ファイル
					func_eventlog(LOG_TYPE_DEBUG, format("exists attachment file. (%s)" % (part.get_filename)))
					continue
				
				# 文字コードチェック
				charset = part.get_content_charset()
				if charset != None:
					# デコード
					payload = payload.decode(charset, "ignore")
					func_eventlog(LOG_TYPE_DEBUG, format("%s decoded." % (charset)))
				
				# base64デコード
				lines = func_decode_from_base64(payload)
				break
		
		# 先頭行のみ取得
		text_message = lines.splitlines()[0]
	
	except:
		# 本文チェック
		if lines == '':
			# 本文なし
			func_eventlog(LOG_TYPE_INFO, format("no body text message."))
		else:
			# 取得エラー
			func_eventlog(LOG_TYPE_ERROR, format("error get text message."), func_get_exception(sys.exc_info()))
		text_message = ''
	
	return text_message

def func_create_file_recv_hist(dir, save_days):

	#
	# 受信履歴ファイル作成関数
	#

	# 初期化
	file  = None
	fname = ''
	
	if dir == '':
		# 履歴保存しない
		return file
	
	try:
		# 現在日時取得
		today_ = datetime.datetime.now()
		
		# ファイル名指定
		fname = format("%04d%02d%02d.lst" % (today_.year, today_.month, today_.day))
		
		if os.path.exists(dir) == True:
			# 保存期間チェック
			files = os.listdir(dir)
			for file in files:
				try:
					if os.path.isfile(dir + "/" + file) == True:
						# ファイル
						create_time = datetime.datetime(int(file[0:4], 10), int(file[4:6], 10), int(file[6:8], 10), 0, 0, 0)
						days = (today_ - create_time).days
						if days > save_days:
							# 保存期間超過
							os.remove(dir + "/" + file)
							func_eventlog(LOG_TYPE_INFO, format("deleted history file. (%s)" % (dir + "/" + file)))
				
				except:
					# エラー
					func_eventlog(LOG_TYPE_INFO, format("error check save days file. (%s)" % (file)))
		
		else:
			#フォルダ作成
			os.makedirs(dir)
			func_eventlog(LOG_TYPE_INFO, format("create directory. (%s)" % (dir)))
		
		# ファイル作成
		file = open(dir + "/" + fname, mode = 'ab')
	
	except:
		# エラー
		func_eventlog(LOG_TYPE_ERROR, format("error create history file. (%s)" % (dir + "/" + fname)), func_get_exception(sys.exc_info()))
		file = None
	
	return file

def func_write_file_recv_hist(line, file, dir, max_size):
	
	#
	# 受信履歴書き込み関数
	#
	
	# 初期化
	ret = True
	
	if file == None:
		# 履歴保存しない
		return ret
	
	try:
		# 履歴書き込み
		file.write(line)
		
		# 受信履歴総サイズチェック
		func_check_size_recv_hist(dir, max_size)
	
	except:
		# エラー
		func_eventlog(LOG_TYPE_ERROR, format("error write history file. (%s)" % (line)), func_get_exception(sys.exc_info()))
		ret = False
	
	return ret

def func_check_size_recv_hist(dir, max_size):
	
	#
	# 受信履歴総サイズチェック関数
	#
	
	# 初期化
	file        = None
	total_size  = 0
	path_del    = ''
	oldest_time = datetime.datetime(2099, 12, 31, 23, 59, 59)
	
	try:
		if os.path.exists(dir) == True:
			# 総サイズ算出 + 最古ファイル検出
			files = os.listdir(dir)
			for file in files:
				if os.path.isfile(dir + "/" + file) == True:
					# ファイル
					total_size  += os.path.getsize(dir + "/" + file)														# サイズ加算
					create_time  = datetime.datetime(int(file[0:4], 10), int(file[4:6], 10), int(file[6:8], 10), 0, 0, 0)	# 作成日時取得
					if create_time < oldest_time:
						# 最古更新
						oldest_time = create_time
						path_del    = dir + "/" + file
			
			if total_size > (max_size):
				# サイズ超過
				if path_del != '':
					# 最古ファイル削除
					os.remove(path_del)
	
	except:
		# エラー
		func_eventlog(LOG_TYPE_ERROR, format("error check size history files. (%s)" % (path_del)), func_get_exception(sys.exc_info()))
	
	return
