# coding=UTF-8

#
#  定義ファイル
#
#      @package    all_define.py
#      @author     M.Suzuki
#      @since      ---
#      @encode     UTF-8
#

# 結果
RET_ERROR_SUCCESS                       = 0x0000									# 正常終了
RET_ERROR_NO_RECV                       = 0x0011									# エラー：受信メールなし
RET_ERROR_GET_MAIL_COUNT                = 0x0012									#       ：受信メール数取得
RET_ERROR_DELETE_MAIL                   = 0x0014									#       ：メール削除
RET_ERROR_CONNECT                       = 0x0021									#       ：サーバ接続
RET_ERROR_START_TLS                     = 0x0022									#       ：TLS通信開始
RET_ERROR_LOGIN                         = 0x0024									#       ：サーバ認証
RET_ERROR_NOT_SUPPORTED                 = 0x0028									#       ：非対応
RET_ERROR_SEND_MAIL                     = 0x0041									#       ：メール送信
RET_ERROR_RECV_MAIL                     = 0x0042									#       ：メール受信
RET_ERROR_RECV_TEXT                     = 0x0044									#       ：受信データ
RET_ERROR_CREATE_FILE                   = 0x0081									#       ：ファイル作成
RET_ERROR_WRITE_FILE                    = 0x0082									#       ：ファイル書き込み
RET_ERROR_READ_FILE                     = 0x0084									#       ：ファイル読み込み
RET_ERROR_READ_FILE_MSG                 = 0x0088									#       ：本文ファイル読み込み

# 処理状態
STATUS_SEND_SMTP_INIT                   = 0											# SMTP送信：初期処理中
STATUS_SEND_SMTP_CONNECT                = 100										#         ：SMTP接続中
STATUS_SEND_SMTP_START_TLS              = 200										#         ：TLS通信開始中
STATUS_SEND_SMTP_LOGIN                  = 300										#         ：SMTP認証中
STATUS_SEND_SMTP_SEND_MAIL              = 400										#         ：メール送信中
STATUS_RECV_IMAP_INIT                   = 0											# IMAP受信：初期処理中
STATUS_RECV_IMAP_CONNECT                = 100										#         ：IMAP接続中
STATUS_RECV_IMAP_START_TLS              = 200										#         ：TLS通信開始中
STATUS_RECV_IMAP_LOGIN                  = 300										#         ：IMAP認証中
STATUS_RECV_IMAP_RECV_MAIL              = 400										#         ：メール受信中
STATUS_RECV_POP3_INIT                   = STATUS_RECV_IMAP_INIT						# POP3受信：初期処理中
STATUS_RECV_POP3_CONNECT                = STATUS_RECV_IMAP_CONNECT					#         ：POP3接続中
STATUS_RECV_POP3_START_TLS              = STATUS_RECV_IMAP_START_TLS				#         ：TLS通信開始中
STATUS_RECV_POP3_LOGIN                  = STATUS_RECV_IMAP_LOGIN					#         ：POP3認証中
STATUS_RECV_POP3_RECV_MAIL              = STATUS_RECV_IMAP_RECV_MAIL				#         ：メール受信中

# 引数
ARGV_NO_MY_FNAME                       = 0											# 自ファイル名
ARGV_NO_SEND_SMTP_SERVER               = 1											# SMTP送信：SMTPサーバ
ARGV_NO_SEND_SMTP_PORT                 = 2											#         ：SMTPポート
ARGV_NO_SEND_SMTP_USER                 = 3											#         ：SMTPユーザ
ARGV_NO_SEND_SMTP_PW                   = 4											#         ：SMTPパスワード
ARGV_NO_SEND_SMTP_TIMEOUT              = 5											#         ：SMTPタイムアウト
ARGV_NO_SEND_SMTP_AUTH_TYPE            = 6											#         ：認証方式
ARGV_NO_SEND_SMTP_FROM_ADDR            = 7											#         ：送信元アドレス
ARGV_NO_SEND_SMTP_FROM_NAME            = 8											#         ：送信者名
ARGV_NO_SEND_SMTP_INPUT_PATH           = 9											#         ：送信情報入力元
ARGV_NO_SEND_SMTP_INPUT_ENCODE         = 10											#         ：送信情報文字コード
ARGV_NO_SEND_SMTP_OUTPUT_PATH          = 11											#         ：送信情報出力先
ARGV_NO_SEND_SMTP_DIR_LOG              = 12											#         ：ログ保存先
ARGV_NO_SEND_SMTP_SIZE_LOG             = 13											#         ：ログサイズ
ARGV_NO_SEND_SMTP_CNT_LOG              = 14											#         ：ログ履歴保存数
ARGV_NO_SEND_SMTP_PHASE                = 15											#         ：プロセスフェーズ
ARGV_NO_RECV_IMAP_SERVER               = 1											# IMAP受信：IMAPサーバ
ARGV_NO_RECV_IMAP_PORT                 = 2											#         ：IMAPポート
ARGV_NO_RECV_IMAP_USER                 = 3											#         ：IMAPユーザ
ARGV_NO_RECV_IMAP_PW                   = 4											#         ：IMAPパスワード
ARGV_NO_RECV_IMAP_AUTH_TYPE            = 5											#         ：認証方式
ARGV_NO_RECV_IMAP_MAX_COUNT            = 6											#         ：受信メール上限数
ARGV_NO_RECV_IMAP_SEARCH_KEY           = 7											#         ：受信検索キー
ARGV_NO_RECV_IMAP_OUTPUT_PATH          = 8											#         ：受信情報出力先
ARGV_NO_RECV_IMAP_SAVE_DAYS            = 9											#         ：受信履歴保存期間
ARGV_NO_RECV_IMAP_DIR_RECV_HIST        = 10											#         ：受信履歴保存先
ARGV_NO_RECV_IMAP_DIR_LOG              = 11											#         ：ログ保存先
ARGV_NO_RECV_IMAP_SIZE_LOG             = 12											#         ：ログサイズ
ARGV_NO_RECV_IMAP_CNT_LOG              = 13											#         ：ログ履歴保存数
ARGV_NO_RECV_IMAP_PHASE                = 14											#         ：プロセスフェーズ
ARGV_NO_RECV_POP3_SERVER               = 1											# POP3受信：POP3サーバ
ARGV_NO_RECV_POP3_PORT                 = 2											#         ：POP3ポート
ARGV_NO_RECV_POP3_USER                 = 3											#         ：POP3ユーザ
ARGV_NO_RECV_POP3_PW                   = 4											#         ：POP3パスワード
ARGV_NO_RECV_POP3_TIMEOUT              = 5											#         ：POP3タイムアウト
ARGV_NO_RECV_POP3_AUTH_TYPE            = 6											#         ：認証方式
ARGV_NO_RECV_POP3_MAX_COUNT            = 7											#         ：受信メール上限数
ARGV_NO_RECV_POP3_OUTPUT_PATH          = 8											#         ：受信情報出力先
ARGV_NO_RECV_POP3_SAVE_DAYS            = 9											#         ：受信履歴保存期間
ARGV_NO_RECV_POP3_DIR_RECV_HIST        = 10											#         ：受信履歴保存先
ARGV_NO_RECV_POP3_DIR_LOG              = 11											#         ：ログ保存先
ARGV_NO_RECV_POP3_SIZE_LOG             = 12											#         ：ログサイズ
ARGV_NO_RECV_POP3_CNT_LOG              = 13											#         ：ログ履歴保存数
ARGV_NO_RECV_POP3_PHASE                = 14											#         ：プロセスフェーズ

# 曜日
WEEK_SUN                                = 0											# 日曜日
WEEK_MON                                = 1											# 月曜日
WEEK_THU                                = 2											# 火曜日
WEEK_WED                                = 3											# 水曜日
WEEK_THU                                = 4											# 木曜日
WEEK_FRI                                = 5											# 金曜日
WEEK_STA                                = 6											# 土曜日
# 日時
DATETIME_YEAR_INIT                      = 1970										# 年
DATETIME_MONTH_INIT                     = 1											# 月
DATETIME_DAY_INIT                       = 1											# 日
DATETIME_WEEK_INIT                      = WEEK_THU									# 曜日
DATETIME_HOUR_INIT                      = 0											# 時
DATETIME_MINUTE_INIT                    = 0											# 分
DATETIME_SECOND_INIT                    = 0											# 秒
# 時刻補正
TIMEDIFF_JAPAN_HOUR                     = 9											# 日本標準時：時
TIMEDIFF_JAPAN_MINUTE                   = 0											#           ：分

# ログ
LOG_TYPE_INFO                           = 'Ntc'										# 種別      ：情報
LOG_TYPE_ERROR                          = 'Err'										#           ：エラー
LOG_TYPE_DEBUG                          = 'Dbg'										#           ：デバッグ
LOG_PATH_SEND                           = 'mail_py_send.log'						# ファイル名：メール送信
LOG_PATH_RECV                           = 'mail_py_recv.log'						#           ：メール送信
LOG_DATA_PRO_ID                         = 5                                         # データ    ：プロセスID
LOG_DATA_THR_ID                         = 0                                         #           ：スレッドID

# 文字コード
ENCODE_UTF_8                            = 'utf-8'                                   # UTF-8
ENCODE_EUC_JP                           = 'euc_jis_2004'                            # EUC-JP

# フォーマット
FMT_FNAME_LOG_HST                       = '%s.%02d'                                 # ログ履歴

# プロセスフェーズ
PHASE_DATA_NORMAL                       = 0x00                                      # 通常
PHASE_DATA_LOG                          = 0x01                                      # ログ出力
PHASE_DATA_DEBUG                        = 0x02                                      # デバッグ出力

# 設定値
SETTING_DATA_AUTH_TYPE_NONE             = 0											# データ：認証方式：認証なし
SETTING_DATA_AUTH_TYPE_SSL_TLS          = 1											#       ：        ：SSL/TLS認証
SETTING_DATA_AUTH_TYPE_STARTTLS         = 2											#       ：        ：STARTTLS認証
SETTING_INIT_SEND_SMTP_SERVER           = ''										# 初期値：SMTP送信：SMTPサーバ
SETTING_INIT_SEND_SMTP_PORT             = 25										#       ：        ：SMTPポート
SETTING_INIT_SEND_SMTP_USER             = ''										#       ：        ：SMTPユーザ
SETTING_INIT_SEND_SMTP_PW               = ''										#       ：        ：SMTPパスワード
SETTING_INIT_SEND_SMTP_TIMEOUT          = 60                        				#       ：        ：SMTPタイムアウト
SETTING_INIT_SEND_SMTP_AUTH_TYPE        = SETTING_DATA_AUTH_TYPE_NONE				#       ：        ：認証方式
SETTING_INIT_SEND_SMTP_FROM_ADDR        = ''										#       ：        ：送信元アドレス
SETTING_INIT_SEND_SMTP_FROM_NAME        = ''										#       ：        ：送信者名
SETTING_INIT_SEND_SMTP_INPUT_PATH       = './send_list.csv'							#       ：        ：送信情報入力元
SETTING_INIT_SEND_SMTP_INPUT_ENCODE     = 'utf-8'									#       ：        ：送信情報文字コード
SETTING_INIT_SEND_SMTP_OUTPUT_PATH      = './send_mails.csv'						#       ：        ：送信情報出力先
SETTING_INIT_SEND_SMTP_DIR_LOG          = '/opt/TAKACOM/tklog/dbg'					#       ：        ：ログ保存先
SETTING_INIT_SEND_SMTP_SIZE_LOG         = 1000										#       ：        ：ログサイズ
SETTING_INIT_SEND_SMTP_CNT_LOG          = 2											#       ：        ：ログ履歴保存数
SETTING_INIT_SEND_SMTP_PHASE            = 0											#       ：        ：プロセスフェーズ
SETTING_INIT_RECV_IMAP_SERVER           = ''										#       ：IMAP受信：IMAPサーバ
SETTING_INIT_RECV_IMAP_PORT             = 110										#       ：        ：IMAPポート
SETTING_INIT_RECV_IMAP_USER             = ''										#       ：        ：IMAPユーザ
SETTING_INIT_RECV_IMAP_PW               = ''										#       ：        ：IMAPパスワード
SETTING_INIT_RECV_IMAP_AUTH_TYPE        = SETTING_DATA_AUTH_TYPE_NONE				#       ：        ：認証方式
SETTING_INIT_RECV_IMAP_MAX_COUNT        = 50										#       ：        ：受信メール上限数
SETTING_INIT_RECV_IMAP_SEARCH_KEY       = 'UNSEEN'									#       ：        ：受信検索キー
SETTING_INIT_RECV_IMAP_OUTPUT_PATH      = './recv_mails.csv'						#       ：        ：受信情報出力先
SETTING_INIT_RECV_IMAP_SAVE_DAYS        = 10										#       ：        ：受信履歴保存期間
SETTING_INIT_RECV_IMAP_DIR_RECV_HIST    = '/opt/TAKACOM/lst/mail'					#       ：        ：受信履歴保存先
SETTING_INIT_RECV_IMAP_DIR_LOG          = '/opt/TAKACOM/tklog/dbg'					#       ：        ：ログ保存先
SETTING_INIT_RECV_IMAP_SIZE_LOG         = 1000										#       ：        ：ログサイズ
SETTING_INIT_RECV_IMAP_CNT_LOG          = 2											#       ：        ：ログ履歴保存数
SETTING_INIT_RECV_IMAP_PHASE            = 0											#       ：        ：プロセスフェーズ
SETTING_INIT_RECV_POP3_SERVER           = SETTING_INIT_RECV_IMAP_SERVER				#       ：POP3受信：POP3サーバ
SETTING_INIT_RECV_POP3_PORT             = SETTING_INIT_RECV_IMAP_PORT				#       ：        ：POP3ポート
SETTING_INIT_RECV_POP3_USER             = SETTING_INIT_RECV_IMAP_USER				#       ：        ：POP3ユーザ
SETTING_INIT_RECV_POP3_PW               = SETTING_INIT_RECV_IMAP_PW					#       ：        ：POP3パスワード
SETTING_INIT_RECV_POP3_TIMEOUT          = 60										#       ：        ：POP3タイムアウト
SETTING_INIT_RECV_POP3_AUTH_TYPE        = SETTING_INIT_RECV_IMAP_AUTH_TYPE			#       ：        ：認証方式
SETTING_INIT_RECV_POP3_MAX_COUNT        = SETTING_INIT_RECV_IMAP_MAX_COUNT			#       ：        ：受信メール上限数
SETTING_INIT_RECV_POP3_OUTPUT_PATH      = SETTING_INIT_RECV_IMAP_OUTPUT_PATH		#       ：        ：受信情報出力先
SETTING_INIT_RECV_POP3_SAVE_DAYS        = SETTING_INIT_RECV_IMAP_SAVE_DAYS			#       ：        ：受信履歴保存期間
SETTING_INIT_RECV_POP3_DIR_RECV_HIST    = '/opt/TAKACOM/lst/mail'					#       ：        ：受信履歴保存先
SETTING_INIT_RECV_POP3_DIR_LOG          = '/opt/TAKACOM/tklog/dbg'					#       ：        ：ログ保存先
SETTING_INIT_RECV_POP3_SIZE_LOG         = 1000										#       ：        ：ログサイズ
SETTING_INIT_RECV_POP3_CNT_LOG          = 2											#       ：        ：ログ履歴保存数
SETTING_INIT_RECV_POP3_PHASE            = 0											#       ：        ：プロセスフェーズ

# データ
DATA_SEND_ERROR_NONE                    = 0											# 送信エラーフラグ：なし
DATA_SEND_ERROR_ERROR                   = 1											#                 ：エラー
DATA_MAX_SIZE_RECV                      = 100000									# 受信サイズ上限
DATA_EXCEPT_MIN                         = 1											# 例外出力        ：最小限
DATA_EXCEPT_DETAIL                      = 2											#                 ：詳細

# 出力ファイル
FILE_COL_RECV_RECV_DATE                 = 0											# 列番号：受信データ：受信日時
FILE_COL_RECV_SEND_DATE                 = 1											#       ：          ：送信日時
FILE_COL_RECV_FROM_ADDR                 = 2											#       ：          ：送信者アドレス
FILE_COL_RECV_TO_ADDR                   = 3											#       ：          ：宛先アドレス
FILE_COL_RECV_TEXT_SUBJECT              = 4											#       ：          ：件名
FILE_COL_RECV_TEXT_MESSAGE              = 5											#       ：          ：本文 (UTF-8)
FILE_COL_RECV_TEXT_MESSAGE_EUC          = 6											#       ：          ：本文 (EUC-JP)
