#!/bin/bash
#file_copy_ver.1.0.0

#引数 本体
ARG_MAIN="prod"
#引数 SD
ARG_SD="sd"
#引数 USB
ARG_USB="usb"
#引数 FTP
ARG_FTP="ftp"
#実行ディレクトリパス
SCRIPT_DIR=$(cd $(dirname $0); pwd)

#デバイスディレクトリ
SD_DEV=/dev/mmcblk1p1
SD_DEV_FOLDER=/dev/mmcblk1p1
#USB_DEV=/dev/sda1
USB_DEV_FOLDER=/dev/sd

#デバイスマウントフォルダ
SD_MNT=/mnt
USB_MNT=/mnt
#本体ディレクトリ
MAIN_DIR=/opt
#tmpディレクトリ
TMP_DIR=/tmp/tk_file
#マウントディレクトリ
MNT_DIR=/mnt
#マウントルートディレクトリ
ROOT_DIR=ARS-900_TAK/opt
#設定値ディレクトリ
DIR_SET=/SETTING
#通知データディレクトリ
DIR_NTC=/NOTICE
#音声ディレクトリ
DIR_MSG=/MESSAGE
#メールディレクトリ
DIR_MAIL=/MAIL
#集計データディレクトリ
DIR_AGGR=/AGGREGATE
#ログディレクトリ
DIR_LOG=/LOG
#ファームウェアディレクトリ
DIR_FIRM=/FIRMWARE
#メンテナンス用sh
DIR_MAINTENANCE_SH=/takacom_maintenance.sh

#インポートディレクトリ容量(byte)
SETTEI_MAX_MEM=46000
MAIL_MAX_MEM=86000
NOTICE_MAX_MEM=13631488
MESSAGE_MAX_MEM=307200

#許容容量(キロバイト)
#DIR_MIN_MEM=15728640
DIR_MIN_MEM=512000
#USB_MIN_MEM=15728640
USB_MIN_MEM=512000
#SD_MIN_MEM=15728640
SD_MIN_MEM=512000

#SDマウントフラグ
SD_MNT_FLG=2
#USBマウントフラグ
USB_MNT_FLG=2
#USBエクスポートフラグ
EX_USB=0

#エラー情報
#ERR_INF

#以下使用ファイル
#コピー元
CP_SRC=/
#コピー先
CP_DST=/
#コピー元ファイル名
FNAME=$3
#コピー先ファイル名
FPATH=${FNAME%/*}
#有無チェック対象フォルダ
EXIST_PATH=$4

#############################shell関数##################################
sd_mnt(){
  #echo "sd_${1}"
  #echo "sd_dev_${SD_DEV_FOLDER}"  
  if [ -e $SD_DEV_FOLDER ]; then
    if ! mount $1 -t vfat $SD_DEV_FOLDER $SD_MNT ; then
      #マウント失敗
      #再マウントを実施して、確認する
      umount $SD_MNT
      if ! mount $1 -t vfat $SD_DEV_FOLDER $SD_MNT ; then
        #マウント失敗
        #echo "SD mount ERR"
        SD_MNT_FLG=1
        return 1
      fi
    fi
  else
    #マウント失敗
    #echo "SD no_dev ERR"
    SD_MNT_FLG=1
    return 1
  fi
  
  SD_MNT_FLG=0  
  return 0
}

usb_mnt(){
  #echo usb_$1!!!!!$2
  if [ -e $2 ]; then
    if ! mount $1 -t vfat $2 $USB_MNT ; then
      #マウント失敗
      #再マウントを実施して、確認する
      umount $USB_MNT
      if ! mount $1 -t vfat $2 $USB_MNT ; then
        #マウント失敗
        USB_MNT_FLG=1
        return 1
      fi
    fi
  else
    #マウント失敗
    USB_MNT_FLG=1
    return 1
  fi
  USB_MNT_FLG=0
  return 0
}

# インポートディレクトリ容量チェック
dir_mem_chk(){
  #echo dir_${1}!!!!!MAXsize_${2}
  DVAL=`du -sk $1 | awk '{ print $1 }'`
  #echo DVAL=$DVAL
  # 容量チェック
  if [ ${DVAL} -ge $2 ]; then
    #echo ${DVAL}
    #echo "memory ERR"
    #umount $USB_MNT
    return 1
  fi
  return 0
}

#出力先SD容量確認
ex_mem_chk_sd(){
    #echo ${SD_MNT}
    DVAL=`df | grep ${SD_MNT} | tail -1 | awk '{ print $4 }'`
    #echo ${DVAL}
    #空き容量チェック ${USB_MIN_MEM}(???MB)
    if [ ${DVAL} -le ${SD_MIN_MEM} ]; then
      #echo ${DVAL}
      #echo "memory ERR"
      umount $SD_MNT
      return 1
    fi
    return 0
}

#出力先USB容量確認
ex_mem_chk_usb(){
    #echo ${USB_MNT}
    DVAL=`df | grep ${USB_MNT} | tail -1 | awk '{ print $4 }'`
    #echo ${DVAL}
    #空き容量チェック ${USB_MIN_MEM}(???MB)
    if [ ${DVAL} -le ${USB_MIN_MEM} ]; then
      #echo ${DVAL}
      #echo "memory ERR"
      umount $USB_MNT
      return 1
    fi
    return 0
}

#############################実処理##################################
#引数1チェック(コピー元)
case $1 in
	${ARG_MAIN} )
		CP_SRC=${MAIN_DIR}/${FNAME}
	;;
	${ARG_SD} )
		#mount $SD_DEV $MNT_DIR
		CP_SRC=${MNT_DIR}/${FNAME}
		
		sd_cmd="-r"
      	sd_mnt $sd_cmd
      	#echo "inSD mount COMP"
	;;
	${ARG_USB} )
		#mount $USB_DEV $MNT_DIR
		CP_SRC=${MNT_DIR}/${ROOT_DIR}/${FNAME}

		usb_cmd="-r"
    	usb_dev_num=1
      	#スリープ
    	sleep 1s
    	USB_DEV_FOLDER=`fdisk -l /dev/sd* | grep /dev/sd | tail -n 1 | cut -c-8`
    	#echo "usb_dev_f=$USB_DEV_FOLDER"
    	if [ ! -z "${USB_DEV_FOLDER}" ]; then
        	usb_mnt $usb_cmd ${USB_DEV_FOLDER}${usb_dev_num}
        if [ $USB_MNT_FLG -eq 1 ]; then
        	#echo "first mount ERR"
        	usb_mnt $usb_cmd ${USB_DEV_FOLDER}
        fi
      	else
        	USB_MNT_FLG=1
      	fi
	;;
	${ARG_FTP} )
		CP_SRC=${TMP_DIR}/${FNAME#/TAKACOM*}
	;;
	*)
		echo "引数1 異常 : $1"
		return 5
	;;
esac

#入力マウント結果
if [ $SD_MNT_FLG -eq 1 -o $USB_MNT_FLG -eq 1 ]; then
	#echo "in mount ERR"
	ret=1
	return 1
	exit $ret
fi

#入力ファイル存在結果
if [ ! -e $CP_SRC ]; then
	echo "non dir err:$CP_SRC"
	ret=4
	return 4
	exit $ret
fi

echo "CP_SRC:$CP_SRC"

#引数2チェック(コピー先)
case $2 in	
	${ARG_MAIN} )	
		#出力対象外
		return 6
	;;
	${ARG_SD} )
		#出力対象外
		return 6
	;;
	${ARG_USB} )
		#mount $USB_DEV $MNT_DIR
		CP_DST=${MNT_DIR}/${ROOT_DIR}/${FPATH}
		usb_cmd="-w"
    	usb_dev_num=1
      	#スリープ
    	sleep 1s
    	USB_DEV_FOLDER=`fdisk -l /dev/sd* | grep /dev/sd | tail -n 1 | cut -c-8`
		#echo "usb_dev_f=$USB_DEV_FOLDER"
    	if [ ! -z "${USB_DEV_FOLDER}" ]; then
        	usb_mnt $usb_cmd ${USB_DEV_FOLDER}${usb_dev_num}
        if [ $USB_MNT_FLG -eq 1 ]; then
        	#echo "first mount ERR"
        	usb_mnt $usb_cmd ${USB_DEV_FOLDER}
        fi
      	else
        	USB_MNT_FLG=1
      	fi
	;;
	${ARG_FTP} )
		#出力対象外
		return 6
	;;
	*)
		echo "引数2 異常 : $1"
		return 6
	;;
esac

#出力マウント結果
if [ $SD_MNT_FLG -eq 1 -o $USB_MNT_FLG -eq 1 ]; then
	#echo "out mount ERR"
	ret=1
	return 1
	exit $ret
fi

EXIST_DIR=${MNT_DIR}${EXIST_PATH}
echo "dir_exist_chk:${EXIST_DIR}"

#フォルダ有無チェック
if [ ! -d ${EXIST_DIR} ]; then
	# フォルダが存在しない
	#echo "not exist DIR"
	
	#フォルダが存在しない場合umountして終了するように改修 2024/11/11
	umount $USB_MNT
	ret=3
	return 3
	exit $ret
fi

echo "CP_DST:$CP_DST"

mkdir -p $CP_SRC
mkdir -p $CP_DST

#出力容量確認
case $2 in
	#SD
	${ARG_SD})
	;;
	#USB
	${ARG_USB})
		ex_mem_chk_usb
		#出力先容量確認結果
		if [ $? -eq 1 ]; then
			#echo "out mount ERR"
			ret=2
			return 2
			exit $ret
		fi		
		if [[ "$CP_SRC" =~ "/lst" ]]; then			
			rm -r /mnt/ARS-900_TAK/opt/TAKACOM/lst/*
		fi
		if [[ "$CP_SRC" =~ "/MESSAGE" ]]; then
			rm -r /mnt/ARS-900_TAK/opt/TAKACOM/set/MESSAGE/*
		fi
	;;
	#本体
	${ARG_MAIN} )
	;;
	#FTP
	${ARG_FTP} )
	;;
	default)
	;;
esac

#旧処理comment
#SDかUSBを使用する場合はマウントする
#if [ $1=ARG_USB ] || [ $2=ARG_USB ]; then
#  mount -w -t vfat /dev/sda1 /mnt
#elif [ $1=ARG_SD ] || [ $2=ARG_SD ]; then
#  mount -w -t vfat /dev/mmcblk1p2 /mnt
#fi
#VBOXでのデバッグ用
#if [ $1=ARG_SD ] || [ $2=ARG_SD ]; then
#  mount -w -t vfat /dev/sdb1 /mnt
#elif [ $1=ARG_USB ] || [ $2=ARG_USB ]; then
#  mount -w -t vfat /dev/sdb1 /mnt
#else
# :
#fi

#実コピー処理
cp -r $CP_SRC $CP_DST
ret=$?

#権限付与
chmod -R 0777 $CP_DST

#旧処理comment
#マウントしていた場合はアンマウント処理実施
# var=$mountpoint -q $MNT_DIR > /dev/null 2>&1
# if [ ${var}=0 ] ; then
# 	umount $MNT_DIR
# fi

#echo "SD_MNT_FLG=$SD_MNT_FLG"
if [ $SD_MNT_FLG -eq 0 ]; then
	#echo "sleep in"
	#SDアンマウント前にデータ吐き出し
	sleep 1s
	sync
	sleep 1s
	umount $SD_MNT
fi

#echo "USB_MNT_FLG=$USB_MNT_FLG"
if [ $USB_MNT_FLG -eq 0 ]; then
	#echo "sleep in"
	#USBアンマウント前にデータ吐き出し
	sleep 1s
	sync
	sleep 1s
	umount $USB_MNT
fi
exit $ret