#!/bin/sh

#
#function
#

function delete_directory() {
	dir=$1
	err=$2

	if [ -e $dir ]
	then
		rm -r $dir
		
		#check
		cnt=0
		while true
		do
			sleep 1
			if [ ! -e $dir ]
			then
				#complete remove direcory
				echo "deleted $dir"
				break
			fi
			
			cnt=$cnt+1
			if [ $cnt -ge 30 ]
			then
				#timeout
				echo "error deleted $dir"
				exit $err
			fi
		done
	fi
}

#set -ux
set -u
LANG=C

#define
RTN_OK=0
RTN_ERR_MNT=1
RTN_ERR_DEL_SET=2
RTN_ERR_DEL_REG=3
RTN_ERR_DEL_LST=4
RTN_ERR_DEL_TLOG=5
RTN_ERR_DEL_SLOG=6
RTN_ERR_UMNT=9

#
#main
#

while true
do

	#
	#mount SD card
	#
	echo "start initial"
	mount /dev/mmcblk1p1 /mnt
	
	#check
	cnt=0
	while true
	do
		sleep 1
		if [ -e /mnt/TAKACOM ]
		then
			#complete umount
			echo "mount SD card"
			break
		fi
		
		cnt=$cnt+1
		if [ $cnt -ge 30 ]
		then
			#timeout
			echo "error mount SD card"
			exit $RTN_ERR_MNT
		fi
	done

	#
	#clear data of SD card
	#
	echo "clear SD card"

	delete_directory /mnt/TAKACOM/set $RTN_ERR_DEL_SET
	delete_directory /mnt/TAKACOM/reg $RTN_ERR_DEL_REG
	delete_directory /mnt/TAKACOM/lst $RTN_ERR_DEL_LST
	delete_directory /mnt/TAKACOM/tklog $RTN_ERR_DEL_TLOG
	delete_directory /mnt/TAKACOM/syslog $RTN_ERR_DEL_SLOG

	#
	#umount SD card
	#

	umount /mnt

	#check
	cnt=0
	while true
	do
		sleep 1
		if [ ! -z /mnt/TAKACOM ]
		then
			#complete umount
			echo "umount SD card"
			break
		fi
		
		cnt=$cnt+1
		if [ $cnt -ge 30 ]
		then
			#timeout
			echo "error umount SD card"
			exit $RTN_ERR_UMNT
		fi
	done

	#completed initial
	echo "completed initial"
	break;
done

#success
exit $RTN_OK
