#!/bin/sh

# Src Define
# define LAN_CTRL_F_TIME_LOW_LIMIT    1577836800
# define LAN_CTRL_F_TIME_UP_LIMIT     4102444800

# Define
diff_jp_time=32400
diff_out_time_lower=-1576800000
diff_out_time_upper=1576800000
lower_time=1577836800
upper_time=4102444800
midway_time=2840140800
true=0
false=1
exec_cnt=0

# Function
function TIME_SYNC ()
{
    # Ntpdate diff time get
    ntpdate_time=$(ntpdate -q $1 | grep ntpdate | awk '{print $10}')
    if [ -n "$ntpdate_time" ];
    then
        echo has value, ntpdate=$ntpdate_time
    else
        echo no value, end
        exit 1
    fi

    # Get decimal part
    diff_time_dec=$(echo $ntpdate_time | awk -F'[.]' '{print $2}')
    echo diff_time_dec=$diff_time_dec

    # Get integer part
    diff_time_int=$(echo $ntpdate_time | awk -F'[.]' '{print $1}')
    echo diff_time_int=$diff_time_int

    # UTC->JST adjustment
    diff_time_int=$((diff_jp_time+diff_time_int))
    echo diff_time_int-diff_jp_time=$diff_time_int

    # Unix time get
    now_time=$(date +%s)
    echo now_time=$now_time

    # decimal part adjustment
    get_sign=$(awk 'BEGIN {print substr('$diff_time_int', 1, 1)}')
    echo test=$get_sign

    # adjustment under millisecond and comm delay
    diff_time_dec=`expr 1000000 - $diff_time_dec`
    if [ "$get_sign" == "-"  ];
    then
        echo MAINASU
        usleep $diff_time_dec
        usleep 500000
        diff_time_int=$((diff_time_int+2))
    else
        echo PLUS
        usleep $diff_time_dec
        usleep 500000
        diff_time_int=$((diff_time_int+1))
    fi
    echo diff_time_int=$diff_time_int

    # integer part adjustment
    sync_time=$((now_time+diff_time_int))
    echo now_time+diff_time_int=$sync_time

    # check range sync_time (2020-2099)
    if [ $diff_time_int -le $diff_out_time_lower -o $diff_time_int -ge $diff_out_time_upper ];
    then
        # adjust to midway_time (2060/01/01)
        echo "over range diff_time"
        sync_time=$midway_time
    else
        if [ $sync_time -lt $lower_time -o $sync_time -gt $upper_time ]
        then
            # adjust to midway_time (2020/01/01)
            echo "over range sync_time to initialize"
            sync_time=$lower_time
        fi
    fi

    # time set
    echo exec_cnt=$exec_cnt
    if [ $exec_cnt -lt 1 ]
    then
        # Command check
        echo non time set
    else
        # *** time ntpdate
        date -s @$sync_time
        echo time set
    fi
}

function CHECK_TIME ()
{
    ntpdate_time=$(ntpdate -q $1 | grep ntpdate | awk '{print $10}')
    diff_time_int=$(echo $ntpdate_time | awk -F'[.]' '{print $1}')
    diff_time_int=$((diff_jp_time+diff_time_int))
    echo CHECK_TIME=$diff_time_int
    if [ "$diff_time_int" -eq 0 ];
    then
        return $true
    else
        return $false
    fi
}

function CHECK_CMD ()
{
    ntpdate -q $1
    result=$(echo $?)

    if [ $result -ne $true ]
    then
        echo ntpdate command false
        return $false
    else
        echo  ntpdate command ture
        return $true
    fi
}

# MAIN
#"--------------------------------------"
#" Command check "
#"--------------------------------------"
echo "---Command check---"

CHECK_CMD $1 exec_cnt
if [ $? -ne 0 ]; then
    exit 1 #END
fi

#"--------------------------------------"
#" First time ntpdate "
#"--------------------------------------"
echo "---First time ntpdate---"

TIME_SYNC $1 exec_cnt
exec_cnt=`expr $exec_cnt + 1`

#"--------------------------------------"
#" Second time ntpdate "
#"--------------------------------------"
echo "---Second time ntpdate---"

TIME_SYNC $1 exec_cnt
exec_cnt=`expr $exec_cnt + 1`

for ((i=1; i<4; i++))
do
    CHECK_TIME $1
    if [ $? -ne 0 ]; then
        echo "---Loop ntpdate---"

        TIME_SYNC $1 # Third time ntpdate
    else
        break
    fi
done

exit 0
