#!/bin/sh

# set -ux
set -u
LANG=C

# [argv]
#  $1:ip address
#  $2:subnet mask (CIDR)
#  $3:default gateway
#  $4:DNS server

# define
TimesyncdConfigPath=/etc/systemd/timesyncd.conf
DNSConfigPath=/run/systemd/resolve/resolv.conf
DNSConfigPathEtc=/etc/resolv.conf
Eth0NetworkPath=/etc/systemd/network/10-eth0.network

sleep 3
rmmod fec

# initial
echo 0 > /sys/class/gpio/export
echo out > /sys/class/gpio/gpio0/direction
echo 1 > /sys/class/gpio/export
echo out > /sys/class/gpio/gpio1/direction

# unlink resolv.conf
unlink $DNSConfigPathEtc
chmod 644 $DNSConfigPathEtc

# eth0 netowork info set
echo "[Match]" > $Eth0NetworkPath
echo "Name=eth0" >> $Eth0NetworkPath
echo "" >> $Eth0NetworkPath
echo "[Network]" >> $Eth0NetworkPath

# ip address and subnet mask
echo "Address=$1/$2" >> $Eth0NetworkPath

# default gateway
if [ "$3" = "0.0.0.0" ]; then
    echo "Gateway=" >> $Eth0NetworkPath
else
    echo gateway set
    echo "Gateway=$3" >> $Eth0NetworkPath
fi
sleep 3

# DNS server
if [ "$4" = "0.0.0.0" ]; then
    echo dnsserver unset
    echo "DNS=" >> $Eth0NetworkPath
    echo "" > $DNSConfigPathEtc
else
    echo dnsserver set
    echo "DNS=$4" >> $Eth0NetworkPath
    echo "nameserver $4" > $DNSConfigPathEtc
fi

# DHCP server
echo "DHCP=no" >> $Eth0NetworkPath

# ipv6 disabled
echo "IPv6AcceptRA=false" >> $Eth0NetworkPath
echo "LinkLocalAddressing=no" >> $Eth0NetworkPath

# chmod
chmod 644 $Eth0NetworkPath

# lan power off and reset on
echo 0 > /sys/class/gpio/gpio0/value
echo 0 > /sys/class/gpio/gpio1/value

# lan power on
sleep 1
echo 1 > /sys/class/gpio/gpio0/value

# lan reset cancellation
sleep 1
echo 1 > /sys/class/gpio/gpio1/value

modprobe fec

sleep 1

# timedatectl ntp disable
timedatectl set-ntp false

# restart service
systemctl restart systemd-networkd.service
systemctl restart systemd-resolved.service
